/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.sonar.plugin.sensor;

import com.buschmais.jqassistant.core.report.schema.v1.ColumnHeaderType;
import com.buschmais.jqassistant.core.report.schema.v1.ColumnType;
import com.buschmais.jqassistant.core.report.schema.v1.ColumnsHeaderType;
import com.buschmais.jqassistant.core.report.schema.v1.ElementType;
import com.buschmais.jqassistant.core.report.schema.v1.ResultType;
import com.buschmais.jqassistant.core.report.schema.v1.RowType;
import com.buschmais.jqassistant.core.report.schema.v1.RuleType;
import com.buschmais.jqassistant.core.report.schema.v1.SeverityType;
import com.buschmais.jqassistant.core.report.schema.v1.SourceType;
import com.buschmais.jqassistant.sonar.plugin.sensor.JQAssistantSensor;
import com.buschmais.jqassistant.sonar.plugin.sensor.LanguageResourceResolver;
import com.buschmais.jqassistant.sonar.plugin.sensor.SourceLocation;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;

abstract class AbstractIssueHandler<T extends RuleType> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JQAssistantSensor.class);
    private final ResourcePerspectives perspectives;
    private final Map<String, LanguageResourceResolver> languageResourceResolvers;
    private SensorContext sensorContext = null;
    private Project project = null;

    protected AbstractIssueHandler(ResourcePerspectives perspectives, Map<String, LanguageResourceResolver> languageResourceResolvers) {
        this.perspectives = perspectives;
        this.languageResourceResolvers = languageResourceResolvers;
    }

    protected Project getProject() {
        return this.project;
    }

    public final void process(Project project, SensorContext sensorContext, T ruleType, RuleKey ruleKey) {
        this.project = project;
        this.sensorContext = sensorContext;
        ResultType result = ruleType.getResult();
        if (result == null) {
            SourceLocation target = this.resolveRelatedResource(null, null);
            if (target == null || target.resource == null) {
                return;
            }
            this.handleIssueBuilding(target.resource, target.lineNumber, ruleType, ruleKey, null, null);
            return;
        }
        String primaryColumn = this.getPrimaryColumn(result);
        for (RowType rowType : result.getRows().getRow()) {
            SourceLocation target = this.resolveRelatedResource(rowType, primaryColumn);
            if (target == null || target.resource == null) continue;
            this.handleIssueBuilding(target.resource, target.lineNumber, ruleType, ruleKey, primaryColumn, rowType);
        }
    }

    private void handleIssueBuilding(Resource resourceResolved, Integer lineNumber, T ruleType, RuleKey ruleKey, String primaryColumn, RowType rowType) {
        Resource resourceIndex = this.sensorContext.getResource(resourceResolved);
        if (resourceIndex == null) {
            LOGGER.warn("Resource '{}' not found, issue not created.", (Object)resourceResolved.getPath());
            return;
        }
        Issuable issuable = (Issuable)this.perspectives.as(Issuable.class, resourceIndex);
        if (issuable == null) {
            LOGGER.warn("Ressource {} isn't issueable; create no violation!", (Object)resourceIndex.getPath());
            return;
        }
        Issuable.IssueBuilder issueBuilder = issuable.newIssueBuilder().ruleKey(ruleKey);
        if (lineNumber != null) {
            issueBuilder.line(lineNumber);
        }
        try {
            String ruleId;
            boolean doIt;
            String severity = this.mapSeverity2SonarQ(ruleType.getSeverity());
            if (severity != null) {
                issueBuilder.severity(severity);
            }
            if (!(doIt = this.fillIssue(issueBuilder, ruleId = ruleType.getId(), ruleType.getDescription(), primaryColumn, rowType))) {
                LOGGER.trace("Issue creation suppressed for {} on row {}", (Object)ruleId, (Object)rowType);
                return;
            }
            issuable.addIssue(issueBuilder.build());
            LOGGER.info("Issue '{}' added for resource '{}'.", (Object)ruleId, (Object)(resourceIndex.getPath() != null ? resourceIndex.getPath() : resourceIndex.getName()));
        }
        catch (Exception ex) {
            LOGGER.error("Problem creating violation", (Throwable)ex);
        }
    }

    private String mapSeverity2SonarQ(SeverityType severity) {
        if (severity == null) {
            return null;
        }
        switch (severity.getLevel()) {
            case 0: {
                return "BLOCKER";
            }
            case 1: {
                return "CRITICAL";
            }
            case 2: {
                return "MAJOR";
            }
            case 3: {
                return "MINOR";
            }
            case 4: {
                return "INFO";
            }
        }
        return null;
    }

    private String getPrimaryColumn(ResultType result) {
        if (result == null) {
            return null;
        }
        ColumnsHeaderType columns = result.getColumns();
        for (ColumnHeaderType columnHeaderType : columns.getColumn()) {
            if (!columnHeaderType.isPrimary()) continue;
            return columnHeaderType.getValue();
        }
        return null;
    }

    private final SourceLocation resolveRelatedResource(RowType rowType, String primaryColumn) {
        if (rowType == null || primaryColumn == null) {
            return this.determineAlternativeResource(rowType);
        }
        for (ColumnType column : rowType.getColumn()) {
            String name = column.getName();
            if (!name.equals(primaryColumn)) continue;
            ElementType languageElement = column.getElement();
            if (languageElement == null) {
                return this.determineAlternativeResource(rowType);
            }
            SourceType source = column.getSource();
            LanguageResourceResolver resourceResolver = this.languageResourceResolvers.get(languageElement.getLanguage().toLowerCase(Locale.ENGLISH));
            if (resourceResolver == null) {
                return this.determineAlternativeResource(rowType);
            }
            String element = languageElement.getValue();
            Resource resource = resourceResolver.resolve(this.project, element, source.getName(), column.getValue());
            if (resource == null) {
                return this.determineAlternativeResource(rowType);
            }
            return new SourceLocation(resource, source.getLine());
        }
        return this.determineAlternativeResource(rowType);
    }

    protected SourceLocation determineAlternativeResource(RowType rowType) {
        return null;
    }

    protected abstract boolean fillIssue(Issuable.IssueBuilder var1, String var2, String var3, String var4, RowType var5);
}

