/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.sonar.plugin.language;

import com.buschmais.jqassistant.plugin.java.api.report.Java;
import com.buschmais.jqassistant.sonar.plugin.sensor.JQAssistantSensor;
import com.buschmais.jqassistant.sonar.plugin.sensor.LanguageResourceResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchExtension;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;

public class JavaResourceResolver
implements LanguageResourceResolver,
BatchExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(JQAssistantSensor.class);
    private final FileSystem fileSystem;

    public JavaResourceResolver(FileSystem moduleFileSystem) {
        this.fileSystem = moduleFileSystem;
    }

    @Override
    public String getLanguage() {
        return "java";
    }

    @Override
    public Resource resolve(Project project, String nodeType, String nodeSource, String nodeValue) {
        if (Java.JavaLanguageElement.Type.name().equals(nodeType)) {
            String javaFilePath = this.determineRelativeQualifiedJavaSourceFileName(nodeSource);
            return this.findMatchingResourceFile(javaFilePath);
        }
        if (Java.JavaLanguageElement.Field.name().equals(nodeType) || Java.JavaLanguageElement.MethodInvocation.name().equals(nodeType) || Java.JavaLanguageElement.ReadField.name().equals(nodeType) || Java.JavaLanguageElement.WriteField.name().equals(nodeType) || Java.JavaLanguageElement.MethodInvocation.name().equals(nodeType)) {
            String javaFilePath = this.determineRelativeQualifiedJavaSourceFileName(nodeSource);
            return this.findMatchingResourceFile(javaFilePath);
        }
        if (Java.JavaLanguageElement.Package.name().equals(nodeType)) {
            return this.findMatchingResourceDirectory(project, nodeValue.replace('.', '/'));
        }
        return null;
    }

    private Resource findMatchingResourceFile(String javaFilePath) {
        Iterator files = this.fileSystem.inputFiles(this.fileSystem.predicates().matchesPathPattern("**/" + javaFilePath)).iterator();
        if (files.hasNext()) {
            InputFile file = (InputFile)files.next();
            if (files.hasNext()) {
                LOGGER.error("Multiple matches for Java file {}, cannot handle source file for violations", (Object)javaFilePath);
                return null;
            }
            return org.sonar.api.resources.File.create((String)file.relativePath());
        }
        return null;
    }

    private Resource findMatchingResourceDirectory(Project project, String javaPackageDirPath) {
        ProjectFileSystem fs = project.getFileSystem();
        ArrayList dirs = new ArrayList(2);
        dirs.addAll(fs.getSourceDirs());
        dirs.addAll(fs.getTestDirs());
        for (File dir : dirs) {
            InputDir id;
            File packageDir = new File(dir, javaPackageDirPath);
            if (!packageDir.exists() || (id = this.fileSystem.inputDir(packageDir)) == null) continue;
            return Directory.fromIOFile((File)id.file(), (Project)project);
        }
        return null;
    }

    private String determineRelativeQualifiedJavaSourceFileName(String classFileName) {
        int index;
        if (classFileName == null || classFileName.isEmpty()) {
            return null;
        }
        String result = classFileName;
        if (result.charAt(0) == '/') {
            result = result.substring(1);
        }
        if (result.toLowerCase(Locale.ENGLISH).endsWith(".class")) {
            result = result.substring(0, result.length() - ".class".length());
        }
        if ((index = result.indexOf(36)) > -1) {
            result = result.substring(0, index);
        }
        return result.concat(".java");
    }
}

