/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.sonar.plugin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.BatchExtension;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.Settings;

public class JQAssistantConfiguration
implements BatchExtension {
    public static final String DISABLED = "sonar.jqassistant.disabled";
    public static final String SUPPRESS_CONCEPTS_FAILURES = "sonar.jqassistant.concept.failures.suppress";
    private final Settings settings;

    public JQAssistantConfiguration(Settings settings) {
        this.settings = settings;
    }

    public String getReportPath() {
        return this.settings.getString("sonar.jqassistant.reportPath");
    }

    public boolean isSensorDisabled() {
        return this.settings.getBoolean(DISABLED);
    }

    public boolean suppressConceptFailures() {
        return this.settings.getBoolean(SUPPRESS_CONCEPTS_FAILURES);
    }

    public static List<PropertyDefinition> getPropertyDefinitions() {
        String subCategory = "jQAssistant";
        return ImmutableList.of((Object)PropertyDefinition.builder((String)"sonar.jqassistant.reportPath").defaultValue("target/jqassistant/jqassistant-report.xml").category("general").subCategory(subCategory).name("jQAssistant Report").description("Path to the jQAssistant report file containing data by checks. The path may be absolute or relative to the project base directory.").onQualifiers("TRK", new String[]{"BRC"}).build(), (Object)PropertyDefinition.builder((String)DISABLED).defaultValue(Boolean.toString(false)).name("Disable").category("general").subCategory(subCategory).description("Do not execute jQAssistant.").onQualifiers("TRK", new String[]{"BRC"}).type(PropertyType.BOOLEAN).build(), (Object)PropertyDefinition.builder((String)SUPPRESS_CONCEPTS_FAILURES).defaultValue(Boolean.toString(true)).name("Suppress concepts failures").category("general").subCategory(subCategory).description("Do not show concepts not applied to an artifact.").onQualifiers("TRK", new String[]{"BRC"}).type(PropertyType.BOOLEAN).build());
    }
}

