/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus.scanners;

import java.net.URL;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.sisu.plexus.annotations.ComponentImpl;
import org.eclipse.sisu.plexus.config.Hints;
import org.eclipse.sisu.plexus.scanners.PlexusTypeListener;
import org.eclipse.sisu.reflect.ClassSpace;
import org.eclipse.sisu.reflect.DeferredClass;
import org.eclipse.sisu.reflect.LoadedClass;
import org.eclipse.sisu.reflect.Logs;
import org.eclipse.sisu.scanners.ClassSpaceScanner;
import org.eclipse.sisu.scanners.ClassSpaceVisitor;
import org.eclipse.sisu.scanners.EmptyAnnotationVisitor;
import org.eclipse.sisu.scanners.EmptyClassVisitor;
import org.eclipse.sisu.scanners.QualifiedTypeListener;
import org.eclipse.sisu.scanners.QualifiedTypeVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

public final class PlexusTypeVisitor
extends EmptyClassVisitor
implements ClassSpaceVisitor {
    private static final String COMPONENT_DESC = Type.getDescriptor(Component.class);
    private final ComponentAnnotationVisitor componentVisitor = new ComponentAnnotationVisitor();
    private final PlexusTypeListener plexusTypeListener;
    private final QualifiedTypeVisitor qualifiedTypeVisitor;
    private ClassSpace space;
    private String source;
    private String implementation;

    public PlexusTypeVisitor(PlexusTypeListener listener) {
        this.plexusTypeListener = listener;
        this.qualifiedTypeVisitor = new QualifiedTypeVisitor((QualifiedTypeListener)listener);
    }

    public void visit(ClassSpace _space) {
        this.space = _space;
        this.source = _space.toString();
        this.qualifiedTypeVisitor.visit(_space);
        if (Logs.TRACE_ENABLED) {
            ClassSpaceScanner.verify((ClassSpace)_space, (Class[])new Class[]{Component.class});
        }
    }

    public ClassVisitor visitClass(URL url) {
        this.componentVisitor.reset();
        this.implementation = null;
        this.qualifiedTypeVisitor.visitClass(url);
        return this;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 0x1600) == 0) {
            this.implementation = name.replace('/', '.');
        }
        this.qualifiedTypeVisitor.visit(version, access, name, signature, superName, interfaces);
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (COMPONENT_DESC.equals(desc)) {
            return this.componentVisitor;
        }
        return this.qualifiedTypeVisitor.visitAnnotation(desc, visible);
    }

    public void visitEnd() {
        if (null != this.implementation) {
            Component component = this.componentVisitor.getComponent(this.space);
            if (null != component) {
                LoadedClass clazz = new LoadedClass(this.space.loadClass(this.implementation));
                this.plexusTypeListener.hear(component, (DeferredClass<?>)clazz, this.source);
            } else {
                this.qualifiedTypeVisitor.visitEnd();
            }
            this.implementation = null;
        }
    }

    static final class ComponentAnnotationVisitor
    extends EmptyAnnotationVisitor {
        private String role;
        private String hint;
        private String strategy;
        private String description;

        ComponentAnnotationVisitor() {
        }

        public void reset() {
            this.role = null;
            this.hint = "default";
            this.strategy = "singleton";
            this.description = "";
        }

        public void visit(String name, Object value) {
            if ("role".equals(name)) {
                this.role = ((Type)value).getClassName();
            } else if ("hint".equals(name)) {
                this.hint = Hints.canonicalHint((String)value);
            } else if ("instantiationStrategy".equals(name)) {
                this.strategy = (String)value;
            } else if ("description".equals(name)) {
                this.description = (String)value;
            }
        }

        public Component getComponent(ClassSpace space) {
            return null != this.role ? new ComponentImpl(space.loadClass(this.role), this.hint, this.strategy, this.description) : null;
        }
    }
}

