/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps.cypher;

import java.io.PrintWriter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Map;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySession;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.OutputAsWriter;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Start
extends TransactionProvidingApp {
    private QueryExecutionEngine engine;

    @Override
    public String getDescription() {
        String className = this.getClass().getSimpleName().toUpperCase();
        return MessageFormat.format("Executes a Cypher query. Usage: {0} <rest of query>;\nExample: MATCH (me)-[:KNOWS]->(you) RETURN you.name;\nwhere '{'self'}' will be replaced with the current location in the graph.Please, note that the query must end with a semicolon. Other parameters are\ntaken from shell variables, see ''help export''.", className);
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        String query = parser.getLine().trim();
        if (this.isComplete(query)) {
            long startTime = System.currentTimeMillis();
            try {
                Result result = this.getResult(this.trimQuery(query), session);
                this.handleResult(out, result, startTime);
            }
            catch (QueryExecutionKernelException e) {
                this.handleException(out, e, startTime);
                return Continuation.EXCEPTION_CAUGHT;
            }
            return Continuation.INPUT_COMPLETE;
        }
        return Continuation.INPUT_INCOMPLETE;
    }

    protected Result getResult(String query, Session session) throws ShellException, RemoteException, QueryExecutionKernelException {
        return this.getEngine().executeQuery(query, this.getParameters(session), Start.shellSession(session));
    }

    protected String trimQuery(String query) {
        return query.substring(0, query.lastIndexOf(";"));
    }

    protected void handleResult(Output out, Result result, long startTime) throws RemoteException, ShellException {
        this.printResult(out, result, startTime);
    }

    private void printResult(Output out, Result result, long startTime) throws RemoteException {
        result.writeAsStringTo(new PrintWriter(new OutputAsWriter(out)));
        out.println((Serializable)((Object)(this.now() - startTime + " ms")));
        if (result.getQueryExecutionType().requestedExecutionPlanDescription()) {
            out.println();
            out.println((Serializable)((Object)result.getExecutionPlanDescription().toString()));
        }
    }

    protected void handleException(Output out, QueryExecutionKernelException exception, long startTime) throws RemoteException {
        out.println((Serializable)((Object)(this.now() - startTime + " ms")));
        out.println();
        out.println((Serializable)((Object)("WARNING: " + exception.getMessage())));
    }

    protected Map<String, Object> getParameters(Session session) throws ShellException {
        try {
            NodeOrRelationship self = this.getCurrent(session);
            session.set("self", self.isNode() ? self.asNode() : self.asRelationship());
        }
        catch (ShellException shellException) {
            // empty catch block
        }
        return session.asMap();
    }

    protected boolean isComplete(String query) {
        return query.endsWith(";");
    }

    protected QueryExecutionEngine getEngine() {
        if (this.engine == null) {
            this.engine = this.getServer().getDb().getDependencyResolver().resolveDependency(QueryExecutionEngine.class);
        }
        return this.engine;
    }

    protected long now() {
        return System.currentTimeMillis();
    }

    static QuerySession shellSession(Session session) {
        return new ShellQuerySession(session);
    }

    private static class ShellQuerySession
    extends QuerySession {
        private final Session session;

        ShellQuerySession(Session session) {
            this.session = session;
        }

        @Override
        public String toString() {
            return String.format("shell-session(%s)", this.session.getId());
        }
    }
}

