/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Mknode
extends TransactionProvidingApp {
    public Mknode() {
        this.addOptionDefinition("np", new OptionDefinition(OptionValueType.MUST, "Properties (a json map) to set for the new node (if one is created)"));
        this.addOptionDefinition("cd", new OptionDefinition(OptionValueType.NONE, "Go to the created node, like doing 'cd'"));
        this.addOptionDefinition("v", new OptionDefinition(OptionValueType.NONE, "Verbose mode: display created node"));
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.MUST, "Labels to attach to the created node, either a single label or a JSON array"));
    }

    @Override
    public String getDescription() {
        return "Creates a new node, f.ex:\nmknode --cd --np \"{'name':'Neo'}\" -l PERSON";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws Exception {
        GraphDatabaseAPI db = this.getServer().getDb();
        Node node = db.createNode(this.parseLabels(parser));
        this.setProperties(node, parser.option("np", null));
        if (parser.options().containsKey("cd")) {
            this.cdTo(session, node);
        }
        if (parser.options().containsKey("v")) {
            out.println((Serializable)((Object)("Node " + Mknode.getDisplayName(this.getServer(), session, node, false) + " created")));
        }
        return Continuation.INPUT_COMPLETE;
    }
}

