/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.Begin;
import org.neo4j.shell.kernel.apps.NonTransactionProvidingApp;

public class Commit
extends NonTransactionProvidingApp {
    @Override
    public String getDescription() {
        return "Commits a transaction";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        if (parser.getLineWithoutApp().trim().length() > 0) {
            out.println((Serializable)((Object)"Error: COMMIT should  be run without trailing arguments"));
            return Continuation.INPUT_COMPLETE;
        }
        Integer txCount = session.getCommitCount();
        TopLevelTransaction tx = Begin.currentTransaction(this.getServer());
        if (txCount == null || txCount.equals(0)) {
            if (tx != null) {
                out.println((Serializable)((Object)"Warning: committing a transaction not started by the shell"));
                txCount = 1;
            } else {
                throw new ShellException("Not in a transaction");
            }
        }
        if (txCount.equals(1)) {
            if (tx == null) {
                throw Commit.fail(session, "Not in a transaction");
            }
            try {
                tx.success();
                tx.close();
                session.remove("TX_COUNT");
                out.println((Serializable)((Object)"Transaction committed"));
                return Continuation.INPUT_COMPLETE;
            }
            catch (Exception e) {
                throw Commit.fail(session, e.getMessage());
            }
        }
        txCount = txCount - 1;
        session.set("TX_COUNT", txCount);
        out.println((Serializable)((Object)String.format("Nested transaction committed (Tx count: %d)", txCount)));
        return Continuation.INPUT_COMPLETE;
    }

    public static ShellException fail(Session session, String message) throws ShellException {
        session.remove("TX_COUNT");
        return new ShellException(message);
    }
}

