/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.apps;

import org.neo4j.helpers.Pair;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TextUtil;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.util.json.JSONParser;

public class Export
extends AbstractApp {
    @Override
    public String getDescription() {
        return "Sets an environment variable. Usage: export <key>=<value>\nF.ex: export NAME=\"Mattias Persson\". Variable names have to be valid identifiers.";
    }

    public static Pair<String, String> splitInKeyEqualsValue(String string) throws ShellException {
        int index = string.indexOf(61);
        if (index == -1) {
            throw new ShellException("Invalid format <key>=<value>");
        }
        String key = string.substring(0, index);
        String value = string.substring(index + 1);
        return Pair.of(key, value);
    }

    @Override
    public Continuation execute(AppCommandParser parser, Session session, Output out) throws ShellException {
        Pair<String, String> keyValue = Export.splitInKeyEqualsValue(parser.getLineWithoutApp());
        String key = keyValue.first();
        String valueString = keyValue.other();
        if (session.has(valueString)) {
            Object value = session.get(valueString);
            session.set(key, value);
            return Continuation.INPUT_COMPLETE;
        }
        Object value = JSONParser.parse(valueString);
        if ((value = this.stripFromQuotesIfString(value)) instanceof String && value.toString().isEmpty()) {
            session.remove(key);
        } else {
            session.set(key, value);
        }
        return Continuation.INPUT_COMPLETE;
    }

    private Object stripFromQuotesIfString(Object value) {
        return value instanceof String ? TextUtil.stripFromQuotes(value.toString()) : value;
    }
}

