/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.InterruptSignalHandler;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.RemoteClient;
import org.neo4j.shell.impl.RmiLocation;
import org.neo4j.shell.impl.SameJvmClient;
import org.neo4j.shell.impl.SystemOutput;

public abstract class ShellLobby {
    public static final Map<String, Serializable> NO_INITIAL_SESSION = Collections.unmodifiableMap(Collections.emptyMap());

    public static ShellServer newServer(Class<? extends ShellServer> cls) throws ShellException {
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ShellClient newClient(ShellServer server, CtrlCHandler signalHandler) throws ShellException {
        return ShellLobby.newClient(server, new HashMap<String, Serializable>(), signalHandler);
    }

    public static ShellClient newClient(ShellServer server) throws ShellException {
        return ShellLobby.newClient(server, new HashMap<String, Serializable>(), (CtrlCHandler)InterruptSignalHandler.getHandler());
    }

    public static ShellClient newClient(ShellServer server, Map<String, Serializable> initialSession, CtrlCHandler signalHandler) throws ShellException {
        return ShellLobby.newClient(server, initialSession, new SystemOutput(), signalHandler);
    }

    public static ShellClient newClient(ShellServer server, Map<String, Serializable> initialSession, Output output, CtrlCHandler signalHandler) throws ShellException {
        return new SameJvmClient(initialSession, server, output, signalHandler);
    }

    public static ShellClient newClient(int port, String name, CtrlCHandler ctrlcHandler) throws ShellException {
        return ShellLobby.newClient("localhost", port, name, ctrlcHandler);
    }

    public static ShellClient newClient(int port) throws ShellException {
        return ShellLobby.newClient("localhost", port);
    }

    public static ShellClient newClient(String host, int port, String name, CtrlCHandler ctrlcHandler) throws ShellException {
        return ShellLobby.newClient(RmiLocation.location(host, port, name), ctrlcHandler);
    }

    public static ShellClient newClient(String host, int port) throws ShellException {
        return ShellLobby.newClient(host, port, "shell", (CtrlCHandler)InterruptSignalHandler.getHandler());
    }

    public static ShellClient newClient(RmiLocation serverLocation, CtrlCHandler ctrlcHandler) throws ShellException {
        return ShellLobby.newClient(serverLocation, new HashMap<String, Serializable>(), ctrlcHandler);
    }

    public static ShellClient newClient(RmiLocation serverLocation, Map<String, Serializable> initialSession, CtrlCHandler ctrlcHandler) throws ShellException {
        return new RemoteClient(initialSession, serverLocation, ctrlcHandler);
    }

    public static ShellClient newClient(String host, CtrlCHandler ctrlcHandler) throws ShellException {
        return ShellLobby.newClient(host, 1337, "shell", ctrlcHandler);
    }

    public static ShellClient newClient() throws ShellException {
        return ShellLobby.newClient("localhost", 1337, "shell", (CtrlCHandler)InterruptSignalHandler.getHandler());
    }

    public static RmiLocation remoteLocation() {
        return ShellLobby.remoteLocation(1337);
    }

    public static RmiLocation remoteLocation(int port) {
        return ShellLobby.remoteLocation(port, "shell");
    }

    public static RmiLocation remoteLocation(int port, String rmiName) {
        return RmiLocation.location("localhost", port, rmiName);
    }
}

