/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.File;
import java.util.Arrays;
import java.util.Random;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;

public class BigLabelStoreGenerator {
    private static Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long batchSize = Long.parseLong(BigLabelStoreGenerator.withDefault(System.getenv().get("BATCH_SIZE"), "100000"));
        long numNodes = Long.parseLong(BigLabelStoreGenerator.withDefault(System.getenv("NUM_NODES"), "1000000"));
        int numLabels = Integer.parseInt(BigLabelStoreGenerator.withDefault(System.getenv("NUM_LABELS"), "5"));
        String graphDbPath = System.getenv("GRAPH_DB");
        System.out.println(String.format("# BATCH_SIZE: %d, NUM_NODES: %d, NUM_LABELS: %d, GRAPH_DB: '%s'", batchSize, numNodes, numLabels, graphDbPath));
        GraphDatabaseService graph = BigLabelStoreGenerator.createGraphDatabaseService(graphDbPath);
        Label[] labels = BigLabelStoreGenerator.createLabels(numLabels);
        int[] statistics = new int[numLabels];
        assert (numLabels == labels.length);
        long labelings = 0L;
        long start = System.currentTimeMillis();
        try {
            for (long l = 0L; l < numNodes; l += batchSize) {
                long batchStart = System.currentTimeMillis();
                try (Transaction tx = graph.beginTx();){
                    for (long m = 0L; m < batchSize; ++m) {
                        Label[] selectedLabels = BigLabelStoreGenerator.pickRandomLabels(labels);
                        int i = 0;
                        while (i < selectedLabels.length) {
                            int n = i++;
                            statistics[n] = statistics[n] + 1;
                        }
                        labelings += (long)selectedLabels.length;
                        graph.createNode(selectedLabels);
                    }
                    tx.success();
                }
                long batchDuration = System.currentTimeMillis() - batchStart;
                System.out.println(String.format("nodes: %d, ratio: %d, labelings: %d, duration: %d, label statistics: %s", l, l * 100L / numNodes, labelings, batchDuration, Arrays.toString(statistics)));
            }
        }
        finally {
            graph.shutdown();
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println(String.format("nodes: %d, ratio: %d, labelings: %d, duration: %d", numNodes, 100, labelings, duration));
    }

    private static GraphDatabaseService createGraphDatabaseService(String graphDbPath) {
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        GraphDatabaseBuilder graphBuilder = factory.newEmbeddedDatabaseBuilder(graphDbPath);
        File propertiesFile = new File(graphDbPath, "neo4j.properties");
        if (propertiesFile.exists() && propertiesFile.isFile() && propertiesFile.canRead()) {
            System.out.println(String.format("# Loading properties file '%s'", propertiesFile.getAbsolutePath()));
            graphBuilder.loadPropertiesFromFile(propertiesFile.getAbsolutePath());
        } else {
            System.out.println(String.format("# No properties file found at '%s'", propertiesFile.getAbsolutePath()));
        }
        return graphBuilder.newGraphDatabase();
    }

    private static String withDefault(String value, String defaultValue) {
        return null == value ? defaultValue : value;
    }

    private static Label[] pickRandomLabels(Label[] labels) {
        return Arrays.copyOf(labels, 1 + random.nextInt(labels.length));
    }

    private static Label[] createLabels(int numLabels) {
        Label[] labels = new DynamicLabel[numLabels];
        for (int i = 0; i < numLabels; ++i) {
            labels[i] = DynamicLabel.label(String.format("LABEL_%d", i));
        }
        return labels;
    }
}

