/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.store;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.legacy.consistency.checking.full.MultiPassStore;
import org.neo4j.legacy.consistency.store.DelegatingRecordAccess;
import org.neo4j.legacy.consistency.store.DiffRecordAccess;
import org.neo4j.legacy.consistency.store.RecordReference;

public class FilteringRecordAccess
extends DelegatingRecordAccess {
    private final Set<MultiPassStore> potentiallySkippableStores = EnumSet.noneOf(MultiPassStore.class);
    private final int iPass;
    private final long recordsPerPass;
    private final MultiPassStore currentStore;

    public FilteringRecordAccess(DiffRecordAccess delegate, int iPass, long recordsPerPass, MultiPassStore currentStore, MultiPassStore ... potentiallySkippableStores) {
        super(delegate);
        this.iPass = iPass;
        this.recordsPerPass = recordsPerPass;
        this.currentStore = currentStore;
        this.potentiallySkippableStores.addAll(Arrays.asList(potentiallySkippableStores));
    }

    @Override
    public RecordReference<NodeRecord> node(long id) {
        if (this.shouldSkip(id, MultiPassStore.NODES)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.node(id);
    }

    @Override
    public RecordReference<RelationshipRecord> relationship(long id) {
        if (this.shouldSkip(id, MultiPassStore.RELATIONSHIPS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.relationship(id);
    }

    @Override
    public RecordReference<RelationshipGroupRecord> relationshipGroup(long id) {
        if (this.shouldSkip(id, MultiPassStore.RELATIONSHIP_GROUPS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.relationshipGroup(id);
    }

    @Override
    public RecordReference<PropertyRecord> property(long id) {
        if (this.shouldSkip(id, MultiPassStore.PROPERTIES)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.property(id);
    }

    @Override
    public RecordReference<PropertyKeyTokenRecord> propertyKey(int id) {
        if (this.shouldSkip(id, MultiPassStore.PROPERTY_KEYS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.propertyKey(id);
    }

    @Override
    public RecordReference<DynamicRecord> string(long id) {
        if (this.shouldSkip(id, MultiPassStore.STRINGS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.string(id);
    }

    @Override
    public RecordReference<DynamicRecord> array(long id) {
        if (this.shouldSkip(id, MultiPassStore.ARRAYS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.array(id);
    }

    @Override
    public RecordReference<LabelTokenRecord> label(int id) {
        if (this.shouldSkip(id, MultiPassStore.LABELS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.label(id);
    }

    @Override
    public RecordReference<DynamicRecord> nodeLabels(long id) {
        if (this.shouldSkip(id, MultiPassStore.LABELS)) {
            return RecordReference.SkippingReference.skipReference();
        }
        return super.nodeLabels(id);
    }

    private boolean shouldSkip(long id, MultiPassStore store) {
        return this.potentiallySkippableStores.contains((Object)store) && (!this.isCurrentStore(store) || !MultiPassStore.recordInCurrentPass(id, this.iPass, this.recordsPerPass));
    }

    private boolean isCurrentStore(MultiPassStore store) {
        return this.currentStore == store;
    }

    static enum Mode {
        SKIP,
        FILTER;

    }
}

