/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.report;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.legacy.consistency.RecordType;

public class ConsistencySummaryStatistics {
    private final Map<RecordType, AtomicInteger> inconsistentRecordCount = new EnumMap<RecordType, AtomicInteger>(RecordType.class);
    private final AtomicInteger totalInconsistencyCount = new AtomicInteger();
    private final AtomicLong errorCount = new AtomicLong();
    private final AtomicLong warningCount = new AtomicLong();

    public ConsistencySummaryStatistics() {
        for (RecordType recordType : RecordType.values()) {
            this.inconsistentRecordCount.put(recordType, new AtomicInteger());
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append('{');
        result.append("\n\tNumber of errors: ").append(this.errorCount);
        result.append("\n\tNumber of warnings: ").append(this.warningCount);
        for (Map.Entry<RecordType, AtomicInteger> entry : this.inconsistentRecordCount.entrySet()) {
            if (entry.getValue().get() == 0) continue;
            result.append("\n\tNumber of inconsistent ").append((Object)entry.getKey()).append(" records: ").append(entry.getValue());
        }
        return result.append("\n}").toString();
    }

    public boolean isConsistent() {
        return this.totalInconsistencyCount.get() == 0;
    }

    public int getInconsistencyCountForRecordType(RecordType recordType) {
        return this.inconsistentRecordCount.get((Object)recordType).get();
    }

    public int getTotalInconsistencyCount() {
        return this.totalInconsistencyCount.get();
    }

    void update(RecordType recordType, int errors, int warnings) {
        if (errors > 0) {
            this.inconsistentRecordCount.get((Object)recordType).addAndGet(errors);
            this.totalInconsistencyCount.addAndGet(errors);
            this.errorCount.addAndGet(errors);
        }
        if (warnings > 0) {
            this.warningCount.addAndGet(warnings);
        }
    }
}

