/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.checking.full;

import org.neo4j.function.Predicate;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

class MultiPassAvoidanceCondition<T extends AbstractBaseRecord>
implements Predicate<T> {
    private static final long NO_RECORDS_SEEN = -1L;
    private long firstSeenRecordId = -1L;
    private boolean singlePassCompleted;

    MultiPassAvoidanceCondition() {
    }

    public boolean test(T record) {
        if (this.singlePassCompleted) {
            return false;
        }
        if (this.firstSeenRecordId == record.getLongId()) {
            this.singlePassCompleted = true;
            return false;
        }
        if (this.firstSeenRecordId == -1L) {
            this.firstSeenRecordId = record.getLongId();
        }
        return true;
    }
}

