/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency.checking.full;

import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.legacy.consistency.RecordType;
import org.neo4j.legacy.consistency.checking.CheckerEngine;
import org.neo4j.legacy.consistency.checking.ComparativeRecordChecker;
import org.neo4j.legacy.consistency.checking.full.Owner;
import org.neo4j.legacy.consistency.report.ConsistencyReport;
import org.neo4j.legacy.consistency.report.PendingReferenceCheck;
import org.neo4j.legacy.consistency.store.RecordAccess;
import org.neo4j.legacy.consistency.store.RecordReference;

abstract class DynamicOwner<RECORD extends AbstractBaseRecord>
implements Owner {
    static final ComparativeRecordChecker<DynamicRecord, AbstractBaseRecord, ConsistencyReport.DynamicConsistencyReport> ORPHAN_CHECK = new ComparativeRecordChecker<DynamicRecord, AbstractBaseRecord, ConsistencyReport.DynamicConsistencyReport>(){

        @Override
        public void checkReference(DynamicRecord record, AbstractBaseRecord ignored, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, RecordAccess records) {
            engine.report().orphanDynamicRecord();
        }
    };

    abstract RecordReference<RECORD> record(RecordAccess var1);

    @Override
    public void checkOrphanage() {
    }

    private DynamicOwner() {
    }

    static class Unknown
    extends DynamicOwner<AbstractBaseRecord>
    implements RecordReference<AbstractBaseRecord> {
        private PendingReferenceCheck<AbstractBaseRecord> reporter;

        Unknown() {
        }

        @Override
        RecordReference<AbstractBaseRecord> record(RecordAccess records) {
            this.markInCustody();
            return RecordReference.SkippingReference.skipReference();
        }

        @Override
        public void checkOrphanage() {
            PendingReferenceCheck<AbstractBaseRecord> reporter = this.pop();
            if (reporter != null) {
                reporter.checkReference(null, null);
            }
        }

        void markInCustody() {
            PendingReferenceCheck<AbstractBaseRecord> reporter = this.pop();
            if (reporter != null) {
                reporter.skip();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized PendingReferenceCheck<AbstractBaseRecord> pop() {
            try {
                PendingReferenceCheck<AbstractBaseRecord> pendingReferenceCheck = this.reporter;
                return pendingReferenceCheck;
            }
            finally {
                this.reporter = null;
            }
        }

        @Override
        public synchronized void dispatch(PendingReferenceCheck<AbstractBaseRecord> reporter) {
            this.reporter = reporter;
        }
    }

    static class RelationshipTypeToken
    extends NameOwner<RelationshipTypeTokenRecord, ConsistencyReport.RelationshipTypeConsistencyReport> {
        private final int id;

        RelationshipTypeToken(RelationshipTypeTokenRecord record) {
            this.id = record.getId();
        }

        @Override
        RecordReference<RelationshipTypeTokenRecord> record(RecordAccess records) {
            return records.relationshipType(this.id);
        }
    }

    static class LabelToken
    extends NameOwner<LabelTokenRecord, ConsistencyReport.LabelTokenConsistencyReport> {
        private final int id;

        LabelToken(LabelTokenRecord record) {
            this.id = record.getId();
        }

        @Override
        RecordReference<LabelTokenRecord> record(RecordAccess records) {
            return records.label(this.id);
        }
    }

    static class PropertyKey
    extends NameOwner<PropertyKeyTokenRecord, ConsistencyReport.PropertyKeyTokenConsistencyReport> {
        private final int id;

        PropertyKey(PropertyKeyTokenRecord record) {
            this.id = record.getId();
        }

        @Override
        RecordReference<PropertyKeyTokenRecord> record(RecordAccess records) {
            return records.propertyKey(this.id);
        }
    }

    static abstract class NameOwner<RECORD extends TokenRecord, REPORT extends ConsistencyReport.NameConsistencyReport>
    extends DynamicOwner<RECORD>
    implements ComparativeRecordChecker<RECORD, AbstractBaseRecord, REPORT> {
        NameOwner() {
        }

        @Override
        public void checkReference(RECORD name, AbstractBaseRecord record, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
            ConsistencyReport.NameConsistencyReport report = (ConsistencyReport.NameConsistencyReport)engine.report();
            if (record instanceof RelationshipTypeTokenRecord) {
                ((ConsistencyReport.RelationshipTypeConsistencyReport)report).nameMultipleOwners((RelationshipTypeTokenRecord)record);
            } else if (record instanceof PropertyKeyTokenRecord) {
                ((ConsistencyReport.PropertyKeyTokenConsistencyReport)report).nameMultipleOwners((PropertyKeyTokenRecord)record);
            } else if (record instanceof DynamicRecord) {
                report.nameMultipleOwners((DynamicRecord)record);
            }
        }
    }

    static class Dynamic
    extends DynamicOwner<DynamicRecord>
    implements ComparativeRecordChecker<DynamicRecord, AbstractBaseRecord, ConsistencyReport.DynamicConsistencyReport> {
        private final long id;
        private final RecordType type;

        Dynamic(RecordType type, DynamicRecord record) {
            this.type = type;
            this.id = record.getId();
        }

        @Override
        RecordReference<DynamicRecord> record(RecordAccess records) {
            switch (this.type) {
                case STRING_PROPERTY: {
                    return records.string(this.id);
                }
                case ARRAY_PROPERTY: {
                    return records.array(this.id);
                }
                case PROPERTY_KEY_NAME: {
                    return records.propertyKeyName((int)this.id);
                }
                case RELATIONSHIP_TYPE_NAME: {
                    return records.relationshipTypeName((int)this.id);
                }
            }
            return RecordReference.SkippingReference.skipReference();
        }

        @Override
        public void checkReference(DynamicRecord block, AbstractBaseRecord record, CheckerEngine<DynamicRecord, ConsistencyReport.DynamicConsistencyReport> engine, RecordAccess records) {
            if (record instanceof PropertyRecord) {
                engine.report().nextMultipleOwners((PropertyRecord)record);
            } else if (record instanceof DynamicRecord) {
                engine.report().nextMultipleOwners((DynamicRecord)record);
            } else if (record instanceof RelationshipTypeTokenRecord) {
                engine.report().nextMultipleOwners((RelationshipTypeTokenRecord)record);
            } else if (record instanceof PropertyKeyTokenRecord) {
                engine.report().nextMultipleOwners((PropertyKeyTokenRecord)record);
            }
        }
    }

    static class Property
    extends DynamicOwner<PropertyRecord>
    implements ComparativeRecordChecker<PropertyRecord, AbstractBaseRecord, ConsistencyReport.PropertyConsistencyReport> {
        private final long id;
        private final RecordType type;

        Property(RecordType type, PropertyRecord record) {
            this.type = type;
            this.id = record.getId();
        }

        @Override
        RecordReference<PropertyRecord> record(RecordAccess records) {
            return records.property(this.id);
        }

        @Override
        public void checkReference(PropertyRecord property, AbstractBaseRecord record, CheckerEngine<PropertyRecord, ConsistencyReport.PropertyConsistencyReport> engine, RecordAccess records) {
            if (record instanceof PropertyRecord) {
                if (this.type == RecordType.STRING_PROPERTY) {
                    engine.report().stringMultipleOwners((PropertyRecord)record);
                } else {
                    engine.report().arrayMultipleOwners((PropertyRecord)record);
                }
            } else if (record instanceof DynamicRecord) {
                if (this.type == RecordType.STRING_PROPERTY) {
                    engine.report().stringMultipleOwners((DynamicRecord)record);
                } else {
                    engine.report().arrayMultipleOwners((DynamicRecord)record);
                }
            }
        }
    }
}

