/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.Strings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.recovery.RecoveryRequiredChecker;
import org.neo4j.legacy.consistency.ConsistencyCheckService;
import org.neo4j.legacy.consistency.ConsistencyCheckSettings;
import org.neo4j.legacy.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;

public class ConsistencyCheckTool {
    private static final String RECOVERY = "recovery";
    private static final String CONFIG = "config";
    private static final String PROP_OWNER = "propowner";
    private final ConsistencyCheckService consistencyCheckService;
    private final GraphDatabaseFactory dbFactory;
    private final PrintStream systemError;
    private final ExitHandle exitHandle;
    private final FileSystemAbstraction fs;

    public static void main(String[] args) throws IOException {
        ConsistencyCheckTool tool = new ConsistencyCheckTool(new ConsistencyCheckService(), new GraphDatabaseFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), System.err, ExitHandle.SYSTEM_EXIT);
        try {
            tool.run(args);
        }
        catch (ToolFailureException e) {
            e.exitTool();
        }
    }

    public ConsistencyCheckTool(ConsistencyCheckService consistencyCheckService, GraphDatabaseFactory dbFactory, FileSystemAbstraction fs, PrintStream systemError, ExitHandle exitHandle) {
        this.consistencyCheckService = consistencyCheckService;
        this.dbFactory = dbFactory;
        this.fs = fs;
        this.systemError = systemError;
        this.exitHandle = exitHandle;
    }

    public void run(String ... args) throws ToolFailureException, IOException {
        Args arguments = Args.withFlags((String[])new String[]{RECOVERY, PROP_OWNER}).parse(args);
        File storeDir = this.determineStoreDirectory(arguments);
        Config tuningConfiguration = this.readTuningConfiguration(arguments);
        this.attemptRecoveryOrCheckStateOfLogicalLogs(arguments, storeDir, tuningConfiguration);
        FormattedLogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out);
        try {
            this.consistencyCheckService.runFullConsistencyCheck(storeDir, tuningConfiguration, ProgressMonitorFactory.textual((OutputStream)System.err), (LogProvider)logProvider, this.fs);
        }
        catch (ConsistencyCheckIncompleteException e) {
            throw new ToolFailureException("Check aborted due to exception", e);
        }
    }

    private void attemptRecoveryOrCheckStateOfLogicalLogs(Args arguments, File storeDir, Config tuningConfiguration) {
        if (arguments.getBoolean(RECOVERY, Boolean.valueOf(false), Boolean.valueOf(true)).booleanValue()) {
            this.dbFactory.newEmbeddedDatabase(storeDir).shutdown();
        } else {
            try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs, (Config)tuningConfiguration);){
                if (new RecoveryRequiredChecker(this.fs, pageCache).isRecoveryRequiredAt(storeDir)) {
                    this.systemError.print(Strings.joinAsLines((String[])new String[]{"Active logical log detected, this might be a source of inconsistencies.", "Consider allowing the database to recover before running the consistency check.", "Consistency checking will continue, abort if you wish to perform recovery first.", "To perform recovery before checking consistency, use the '--recovery' flag."}));
                    this.exitHandle.pull();
                }
            }
            catch (IOException e) {
                this.systemError.printf("Failure when checking for recovery state: '%s', continuing as normal.%n", e);
            }
        }
    }

    private File determineStoreDirectory(Args arguments) throws ToolFailureException {
        List unprefixedArguments = arguments.orphans();
        if (unprefixedArguments.size() != 1) {
            throw new ToolFailureException(this.usage());
        }
        File storeDir = new File((String)unprefixedArguments.get(0));
        if (!storeDir.isDirectory()) {
            throw new ToolFailureException(Strings.joinAsLines((String[])new String[]{String.format("'%s' is not a directory", storeDir)}) + this.usage());
        }
        return storeDir;
    }

    private Config readTuningConfiguration(Args arguments) throws ToolFailureException {
        Map specifiedProperties = MapUtil.stringMap((String[])new String[0]);
        String propertyFilePath = arguments.get(CONFIG, null);
        if (propertyFilePath != null) {
            File propertyFile = new File(propertyFilePath);
            try {
                specifiedProperties = MapUtil.load((File)propertyFile);
            }
            catch (IOException e) {
                throw new ToolFailureException(String.format("Could not read configuration properties file [%s]", propertyFilePath), e);
            }
        }
        return new Config(specifiedProperties, new Class[]{GraphDatabaseSettings.class, ConsistencyCheckSettings.class});
    }

    private String usage() {
        return Strings.joinAsLines((String[])new String[]{Args.jarUsage(this.getClass(), (String[])new String[]{"[-propowner] [-recovery] [-config <neo4j.properties>] <storedir>"}), "WHERE:   <storedir>         is the path to the store to check", "         -recovery          to perform recovery on the store before checking", "         <neo4j.properties> is the location of an optional properties file", "                            containing tuning parameters for the consistency check"});
    }

    public class ToolFailureException
    extends Exception {
        ToolFailureException(String message) {
            super(message);
        }

        ToolFailureException(String message, Throwable cause) {
            super(message, cause);
        }

        void exitTool() {
            System.err.println(this.getMessage());
            if (this.getCause() != null) {
                this.getCause().printStackTrace(System.err);
            }
            ConsistencyCheckTool.this.exitHandle.pull();
        }
    }

    public static interface ExitHandle {
        public static final ExitHandle SYSTEM_EXIT = new ExitHandle(){

            @Override
            public void pull() {
                System.exit(1);
            }
        };

        public void pull();
    }
}

