/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.legacy.consistency;

import java.io.File;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.Description;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.legacy.consistency.checking.full.TaskExecutionOrder;

@Description(value="Consistency check configuration settings")
public class ConsistencyCheckSettings {
    @Description(value="Perform optional additional checking on property ownership. This can detect a theoretical inconsistency where a property could be owned by multiple entities. However, the check is very expensive in time and memory, so it is skipped by default.")
    public static final Setting<Boolean> consistency_check_property_owners = Settings.setting((String)"consistency_check_property_owners", (Function)Settings.BOOLEAN, (String)"false");
    @Description(value="Perform checks on the label scan store. Checking this store is more expensive than checking the native stores, so it may be useful to turn off this check for very large databases.")
    public static final Setting<Boolean> consistency_check_label_scan_store = Settings.setting((String)"consistency_check_label_scan_store", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Perform checks on indexes. Checking indexes is more expensive than checking the native stores, so it may be useful to turn off this check for very large databases.")
    public static final Setting<Boolean> consistency_check_indexes = Settings.setting((String)"consistency_check_indexes", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Perform checks between nodes, relationships, properties, types and tokens.")
    public static final Setting<Boolean> consistency_check_graph = Settings.setting((String)"consistency_check_graph", (Function)Settings.BOOLEAN, (String)"true");
    @Description(value="Execution order of store cross-checks to be used when running consistency check")
    public static final Setting<TaskExecutionOrder> consistency_check_execution_order = Settings.setting((String)"consistency_check_execution_order", (Function)Settings.options(TaskExecutionOrder.class), (String)TaskExecutionOrder.MULTI_PASS.name());
    @Description(value="File name for inconsistencies log file. If not specified, logs to a file in the store directory.")
    public static final Setting<File> consistency_check_report_file = Settings.setting((String)"consistency_check_report_file", (Function)Settings.PATH, (String)Settings.NO_DEFAULT);
}

