/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ScannerPluginRepository;
import com.buschmais.jqassistant.core.plugin.impl.AbstractPluginRepository;
import com.buschmais.jqassistant.core.plugin.schema.v1.IdClassType;
import com.buschmais.jqassistant.core.plugin.schema.v1.JqassistantPlugin;
import com.buschmais.jqassistant.core.plugin.schema.v1.ScannerType;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScannerPluginRepositoryImpl
extends AbstractPluginRepository
implements ScannerPluginRepository {
    private final Map<String, ScannerPlugin<?, ?>> scannerPlugins;

    public ScannerPluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) throws PluginRepositoryException {
        super(pluginConfigurationReader);
        List<JqassistantPlugin> plugins = pluginConfigurationReader.getPlugins();
        this.scannerPlugins = this.getScannerPlugins(plugins);
    }

    @Override
    public Map<String, ScannerPlugin<?, ?>> getScannerPlugins(ScannerContext scannerContext, Map<String, Object> properties) throws PluginRepositoryException {
        for (ScannerPlugin<?, ?> scannerPlugin : this.scannerPlugins.values()) {
            scannerPlugin.configure(scannerContext, new HashMap<String, Object>(properties));
        }
        return this.scannerPlugins;
    }

    private <T extends ScannerPlugin> Map<String, T> getScannerPlugins(List<JqassistantPlugin> plugins) throws PluginRepositoryException {
        HashMap<String, ScannerPlugin> scannerPlugins = new HashMap<String, ScannerPlugin>();
        for (JqassistantPlugin plugin : plugins) {
            ScannerType scannerType = plugin.getScanner();
            if (scannerType == null) continue;
            for (IdClassType classType : scannerType.getClazz()) {
                ScannerPlugin scannerPlugin = (ScannerPlugin)this.createInstance(classType.getValue());
                if (scannerPlugin == null) continue;
                scannerPlugin.initialize();
                String id = classType.getId();
                if (id == null) {
                    id = scannerPlugin.getClass().getSimpleName();
                }
                scannerPlugins.put(id, scannerPlugin);
            }
        }
        return scannerPlugins;
    }
}

