/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.analysis.impl.XmlHelper;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.schema.v1.JqassistantPlugin;
import com.buschmais.jqassistant.core.shared.xml.JAXBUnmarshaller;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginConfigurationReaderImpl
implements PluginConfigurationReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginConfigurationReaderImpl.class);
    private static final Schema SCHEMA = XmlHelper.getSchema((String)"/META-INF/xsd/jqassistant-plugin-1.1.xsd");
    private final ClassLoader pluginClassLoader;
    private JAXBUnmarshaller<JqassistantPlugin> jaxbUnmarshaller;
    private List<JqassistantPlugin> plugins = null;

    public PluginConfigurationReaderImpl() {
        this(PluginConfigurationReader.class.getClassLoader());
    }

    public PluginConfigurationReaderImpl(ClassLoader pluginClassLoader) {
        this.pluginClassLoader = pluginClassLoader;
        HashMap<String, String> namespaceMappings = new HashMap<String, String>();
        namespaceMappings.put("http://www.buschmais.com/jqassistant/core/plugin/schema/v1.0", "http://www.buschmais.com/jqassistant/core/plugin/schema/v1.1");
        this.jaxbUnmarshaller = new JAXBUnmarshaller(JqassistantPlugin.class, SCHEMA, namespaceMappings);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JqassistantPlugin readPlugin(URL pluginUrl) {
        try (BufferedInputStream inputStream = new BufferedInputStream(pluginUrl.openStream());){
            JqassistantPlugin jqassistantPlugin = (JqassistantPlugin)this.jaxbUnmarshaller.unmarshal((InputStream)inputStream);
            return jqassistantPlugin;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read plugin from " + pluginUrl.toString(), e);
        }
    }

    @Override
    public List<JqassistantPlugin> getPlugins() {
        if (this.plugins == null) {
            Enumeration<URL> resources;
            try {
                resources = this.pluginClassLoader.getResources("META-INF/jqassistant-plugin.xml");
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot get plugin resources.", e);
            }
            this.plugins = new ArrayList<JqassistantPlugin>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                LOGGER.debug("Reading plugin descriptor from '{}'.", (Object)url);
                this.plugins.add(this.readPlugin(url));
            }
            TreeSet<String> pluginNames = new TreeSet<String>();
            for (JqassistantPlugin plugin : this.plugins) {
                pluginNames.add(plugin.getName());
            }
            LOGGER.info("Loaded jQAssistant plugins {}.", pluginNames);
        }
        return this.plugins;
    }
}

