/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;

public abstract class AbstractPluginRepository {
    private final ClassLoader classLoader;

    protected AbstractPluginRepository(PluginConfigurationReader pluginConfigurationReader) {
        this.classLoader = pluginConfigurationReader.getClassLoader();
    }

    protected <T> Class<T> getType(String typeName) throws PluginRepositoryException {
        try {
            return this.classLoader.loadClass(typeName);
        }
        catch (ClassNotFoundException e) {
            throw new PluginRepositoryException("Cannot find class " + typeName, e);
        }
    }

    protected <T> T createInstance(String typeName) throws PluginRepositoryException {
        Class<T> type = this.getType(typeName.trim());
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginRepositoryException("Cannot create instance of class " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new PluginRepositoryException("Cannot access class " + typeName, e);
        }
    }
}

