/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.interceptor;

import com.buschmais.xo.api.ConcurrencyMode;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.spi.interceptor.InvocationContext;
import com.buschmais.xo.spi.interceptor.XOInterceptor;
import java.util.concurrent.locks.ReentrantLock;

public class ConcurrencyInterceptor
implements XOInterceptor {
    private final ConcurrencyMode concurrencyMode;
    private final ReentrantLock lock;

    public ConcurrencyInterceptor(ConcurrencyMode concurrencyMode) {
        this.concurrencyMode = concurrencyMode;
        this.lock = new ReentrantLock();
    }

    public boolean isActive() {
        return ConcurrencyMode.MULTITHREADED.equals((Object)this.concurrencyMode);
    }

    public Object invoke(InvocationContext invocationContext) throws Throwable {
        switch (this.concurrencyMode) {
            case SINGLETHREADED: {
                return invocationContext.proceed();
            }
            case MULTITHREADED: {
                this.lock.lock();
                try {
                    Object object = invocationContext.proceed();
                    return object;
                }
                finally {
                    this.lock.unlock();
                }
            }
        }
        throw new XOException("Unsupported concurrency mode " + this.concurrencyMode);
    }
}

