/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.instancelistener;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.annotation.PostCreate;
import com.buschmais.xo.api.annotation.PostDelete;
import com.buschmais.xo.api.annotation.PostLoad;
import com.buschmais.xo.api.annotation.PostUpdate;
import com.buschmais.xo.api.annotation.PreDelete;
import com.buschmais.xo.api.annotation.PreUpdate;
import com.buschmais.xo.spi.reflection.ClassHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InstanceListenerService {
    private Map<Object, Set<Method>> postCreateMethods = new IdentityHashMap<Object, Set<Method>>();
    private Map<Object, Set<Method>> preUpdateMethods = new IdentityHashMap<Object, Set<Method>>();
    private Map<Object, Set<Method>> postUpdateMethods = new IdentityHashMap<Object, Set<Method>>();
    private Map<Object, Set<Method>> preDeleteMethods = new IdentityHashMap<Object, Set<Method>>();
    private Map<Object, Set<Method>> postDeleteMethods = new IdentityHashMap<Object, Set<Method>>();
    private Map<Object, Set<Method>> postLoadMethods = new IdentityHashMap<Object, Set<Method>>();

    public InstanceListenerService(List<? extends Class<?>> instanceListenerTypes) {
        for (Class<?> listenerType : instanceListenerTypes) {
            Object instanceListener = ClassHelper.newInstance(listenerType);
            this.registerInstanceListener(instanceListener);
        }
    }

    public <T> void postCreate(T instance) {
        this.invoke(this.postCreateMethods, instance);
    }

    public <T> void preUpdate(T instance) {
        this.invoke(this.preUpdateMethods, instance);
    }

    public <T> void postUpdate(T instance) {
        this.invoke(this.postUpdateMethods, instance);
    }

    public <T> void preDelete(T instance) {
        this.invoke(this.preDeleteMethods, instance);
    }

    public <T> void postDelete(T instance) {
        this.invoke(this.postDeleteMethods, instance);
    }

    public <T> void postLoad(T instance) {
        this.invoke(this.postLoadMethods, instance);
    }

    public void registerInstanceListener(Object instanceListener) {
        for (Method method : instanceListener.getClass().getMethods()) {
            this.evaluateMethod(instanceListener, PostCreate.class, method, this.postCreateMethods);
            this.evaluateMethod(instanceListener, PreUpdate.class, method, this.preUpdateMethods);
            this.evaluateMethod(instanceListener, PostUpdate.class, method, this.postUpdateMethods);
            this.evaluateMethod(instanceListener, PreDelete.class, method, this.preDeleteMethods);
            this.evaluateMethod(instanceListener, PostDelete.class, method, this.postDeleteMethods);
            this.evaluateMethod(instanceListener, PostLoad.class, method, this.postLoadMethods);
        }
    }

    private void evaluateMethod(Object listener, Class<? extends Annotation> annotation, Method method, Map<Object, Set<Method>> methods) {
        if (method.isAnnotationPresent(annotation)) {
            if (method.getParameterTypes().length != 1) {
                throw new XOException("Life cycle method '" + method.toGenericString() + "' annotated with '" + annotation.getName() + "' must declare exactly one parameter but declares " + method.getParameterTypes().length + ".");
            }
            Set<Method> listenerMethods = methods.get(listener);
            if (listenerMethods == null) {
                listenerMethods = new HashSet<Method>();
                methods.put(listener, listenerMethods);
            }
            listenerMethods.add(method);
        }
    }

    private <T> void invoke(Map<Object, Set<Method>> methods, T instance) {
        for (Map.Entry<Object, Set<Method>> entry : methods.entrySet()) {
            Object listener = entry.getKey();
            Set<Method> listenerMethods = entry.getValue();
            if (listenerMethods == null) continue;
            for (Method method : listenerMethods) {
                Class<?> parameterType = method.getParameterTypes()[0];
                if (!parameterType.isAssignableFrom(instance.getClass())) continue;
                try {
                    method.invoke(listener, instance);
                }
                catch (IllegalAccessException e) {
                    throw new XOException("Cannot access instance listener method " + method.toGenericString(), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new XOException("Cannot invoke instance listener method " + method.toGenericString(), (Throwable)e);
                }
            }
        }
    }
}

