/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.cache;

import com.buschmais.xo.api.ValidationMode;
import com.buschmais.xo.impl.SessionContext;
import com.buschmais.xo.impl.instancelistener.InstanceListenerService;
import com.buschmais.xo.spi.datastore.DatastoreSession;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

public class CacheSynchronizationService<Entity, Relation> {
    private final SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext;
    private ValidationMode validationMode;

    public CacheSynchronizationService(SessionContext<?, Entity, ?, ?, ?, Relation, ?, ?, ?> sessionContext, ValidationMode validationMode) {
        this.sessionContext = sessionContext;
        this.validationMode = validationMode;
    }

    public void flush() {
        DatastoreSession<?, Entity, ?, ?, ?, Relation, ?, ?, ?> datastoreSession = this.sessionContext.getDatastoreSession();
        InstanceListenerService instanceListenerService = this.sessionContext.getInstanceListenerService();
        for (Object instance : this.sessionContext.getRelationCache().writtenInstances()) {
            Relation relation = this.sessionContext.getRelationInstanceManager().getDatastoreType(instance);
            instanceListenerService.preUpdate(instance);
            this.validateInstance(instance);
            datastoreSession.getDatastoreRelationManager().flushRelation(relation);
            instanceListenerService.postUpdate(instance);
        }
        for (Object instance : this.sessionContext.getEntityCache().writtenInstances()) {
            Entity entity = this.sessionContext.getEntityInstanceManager().getDatastoreType(instance);
            instanceListenerService.preUpdate(instance);
            this.validateInstance(instance);
            datastoreSession.getDatastoreEntityManager().flushEntity(entity);
            instanceListenerService.postUpdate(instance);
        }
    }

    private void validateInstance(Object instance) {
        Set<ConstraintViolation<Object>> constraintViolations;
        if (!ValidationMode.NONE.equals((Object)this.validationMode) && !(constraintViolations = this.sessionContext.getInstanceValidationService().validate(instance)).isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
    }
}

