/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl.bootstrap;

import com.buschmais.xo.api.XOException;
import com.buschmais.xo.api.XOManagerFactory;
import com.buschmais.xo.api.bootstrap.XOBootstrapService;
import com.buschmais.xo.api.bootstrap.XOUnit;
import com.buschmais.xo.impl.XOManagerFactoryImpl;
import com.buschmais.xo.impl.bootstrap.XOUnitFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class XOBootstrapServiceImpl
implements XOBootstrapService {
    private final XOUnitFactory xoUnitFactory = XOUnitFactory.getInstance();
    private final Map<String, XOUnit> xoUnits = this.readXODescriptors();

    public XOManagerFactory createXOManagerFactory(String name) {
        XOUnit xoUnit = this.xoUnits.get(name);
        if (xoUnit == null) {
            throw new XOException("XO unit with name '" + name + "' does not exist.");
        }
        return this.createXOManagerFactory(xoUnit);
    }

    public XOManagerFactory createXOManagerFactory(XOUnit xoUnit) {
        return new XOManagerFactoryImpl(xoUnit);
    }

    private Map<String, XOUnit> readXODescriptors() {
        HashMap<String, XOUnit> result = new HashMap<String, XOUnit>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = XOUnitFactory.class.getClassLoader();
        }
        try {
            Enumeration<URL> resources = classLoader.getResources("META-INF/xo.xml");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                for (XOUnit xoUnit : this.xoUnitFactory.getXOUnits(url)) {
                    XOUnit existingXOUnit = result.put(xoUnit.getName(), xoUnit);
                    if (existingXOUnit == null) continue;
                    throw new XOException("Found more than one XO unit with name '" + xoUnit.getName() + "'.");
                }
            }
        }
        catch (IOException e) {
            throw new XOException("Cannot read xo.xml descriptors.", (Throwable)e);
        }
        return result;
    }
}

