/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.XOTransaction;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class XOTransactionImpl
implements XOTransaction {
    private final DatastoreTransaction datastoreTransaction;
    private final Collection<XOTransaction.Synchronization> defaultSynchronizations = new LinkedList<XOTransaction.Synchronization>();
    private final Collection<XOTransaction.Synchronization> synchronizations = new LinkedList<XOTransaction.Synchronization>();

    public XOTransactionImpl(DatastoreTransaction datastoreTransaction) {
        this.datastoreTransaction = datastoreTransaction;
    }

    public void begin() {
        this.datastoreTransaction.begin();
    }

    public void commit() {
        this.beforeCompletion();
        boolean committed = false;
        try {
            this.datastoreTransaction.commit();
            committed = true;
        }
        finally {
            this.afterCompletion(committed);
        }
    }

    public void rollback() {
        try {
            this.datastoreTransaction.rollback();
        }
        finally {
            this.afterCompletion(false);
        }
    }

    public boolean isActive() {
        return this.datastoreTransaction.isActive();
    }

    public void registerSynchronization(XOTransaction.Synchronization synchronization) {
        this.synchronizations.add(synchronization);
    }

    public void unregisterSynchronization(XOTransaction.Synchronization synchronization) {
        this.synchronizations.remove(synchronization);
    }

    public void registerDefaultSynchronization(XOTransaction.Synchronization synchronization) {
        this.defaultSynchronizations.add(synchronization);
    }

    private void beforeCompletion() {
        this.executeSynchronizations(new SynchronizationOperation(){

            @Override
            public void run(XOTransaction.Synchronization synchronization) {
                synchronization.beforeCompletion();
            }
        });
    }

    private void afterCompletion(final boolean committed) {
        this.executeSynchronizations(new SynchronizationOperation(){

            @Override
            public void run(XOTransaction.Synchronization synchronization) {
                synchronization.afterCompletion(committed);
            }
        });
        this.synchronizations.clear();
    }

    private void executeSynchronizations(SynchronizationOperation operation) {
        for (XOTransaction.Synchronization synchronization : this.defaultSynchronizations) {
            operation.run(synchronization);
        }
        for (XOTransaction.Synchronization synchronization : new ArrayList<XOTransaction.Synchronization>(this.synchronizations)) {
            operation.run(synchronization);
        }
    }

    private static interface SynchronizationOperation {
        public void run(XOTransaction.Synchronization var1);
    }
}

