/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.impl;

import com.buschmais.xo.api.ConcurrencyMode;
import com.buschmais.xo.api.Transaction;
import com.buschmais.xo.api.ValidationMode;
import com.buschmais.xo.api.XOTransaction;
import com.buschmais.xo.impl.AbstractInstanceManager;
import com.buschmais.xo.impl.EntityInstanceManager;
import com.buschmais.xo.impl.EntityPropertyManager;
import com.buschmais.xo.impl.MetadataProvider;
import com.buschmais.xo.impl.ProxyFactory;
import com.buschmais.xo.impl.RelationInstanceManager;
import com.buschmais.xo.impl.RelationPropertyManager;
import com.buschmais.xo.impl.XOTransactionImpl;
import com.buschmais.xo.impl.cache.CacheSynchronization;
import com.buschmais.xo.impl.cache.CacheSynchronizationService;
import com.buschmais.xo.impl.cache.TransactionalCache;
import com.buschmais.xo.impl.instancelistener.InstanceListenerService;
import com.buschmais.xo.impl.interceptor.ConcurrencyInterceptor;
import com.buschmais.xo.impl.interceptor.TransactionInterceptor;
import com.buschmais.xo.impl.plugin.PluginRepositoryManager;
import com.buschmais.xo.impl.validation.InstanceValidationService;
import com.buschmais.xo.spi.datastore.DatastoreEntityMetadata;
import com.buschmais.xo.spi.datastore.DatastoreRelationMetadata;
import com.buschmais.xo.spi.datastore.DatastoreSession;
import com.buschmais.xo.spi.datastore.DatastoreTransaction;
import com.buschmais.xo.spi.interceptor.InterceptorFactory;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ValidatorFactory;

public class SessionContext<EntityId, Entity, EntityMetadata extends DatastoreEntityMetadata<EntityDiscriminator>, EntityDiscriminator, RelationId, Relation, RelationMetadata extends DatastoreRelationMetadata<RelationDiscriminator>, RelationDiscriminator, PropertyMetadata> {
    private final MetadataProvider<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> metadataProvider;
    private final PluginRepositoryManager pluginRepositoryManager;
    private final AbstractInstanceManager<EntityId, Entity> entityInstanceManager;
    private final AbstractInstanceManager<RelationId, Relation> relationInstanceManager;
    private final InstanceListenerService instanceListenerService;
    private final TransactionalCache<EntityId> entityCache;
    private final TransactionalCache<RelationId> relationCache;
    private final InstanceValidationService instanceValidationService;
    private final CacheSynchronizationService<Entity, Relation> cacheSynchronizationService;
    private final XOTransactionImpl xoTransaction;
    private final EntityPropertyManager<Entity, Relation, PropertyMetadata> entityPropertyManager;
    private final RelationPropertyManager<Entity, Relation> relationPropertyManager;
    private final InterceptorFactory interceptorFactory;
    private final ProxyFactory proxyFactory;
    private final DatastoreSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> datastoreSession;

    public SessionContext(MetadataProvider<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> metadataProvider, PluginRepositoryManager pluginRepositoryManager, DatastoreSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> datastoreSession, ValidatorFactory validatorFactory, List<? extends Class<?>> instanceListenerTypes, Transaction.TransactionAttribute defaultTransactionAttribute, ValidationMode validationMode, ConcurrencyMode concurrencyMode, ClassLoader classLoader) {
        this.metadataProvider = metadataProvider;
        this.pluginRepositoryManager = pluginRepositoryManager;
        this.datastoreSession = datastoreSession;
        this.entityCache = new TransactionalCache();
        this.relationCache = new TransactionalCache();
        DatastoreTransaction datastoreTransaction = datastoreSession.getDatastoreTransaction();
        this.xoTransaction = datastoreTransaction != null ? new XOTransactionImpl(datastoreTransaction) : null;
        ArrayList<Object> interceptorChain = new ArrayList<Object>();
        interceptorChain.add(new ConcurrencyInterceptor(concurrencyMode));
        interceptorChain.add(new TransactionInterceptor(this.xoTransaction, defaultTransactionAttribute));
        this.interceptorFactory = new InterceptorFactory(interceptorChain);
        this.proxyFactory = new ProxyFactory(this.interceptorFactory, classLoader);
        this.instanceListenerService = new InstanceListenerService(instanceListenerTypes);
        this.entityPropertyManager = new EntityPropertyManager(this);
        this.relationPropertyManager = new RelationPropertyManager(this);
        this.relationInstanceManager = new RelationInstanceManager(this);
        this.entityInstanceManager = new EntityInstanceManager(this);
        this.instanceValidationService = new InstanceValidationService(validatorFactory, this.relationCache, this.entityCache);
        this.cacheSynchronizationService = new CacheSynchronizationService(this, validationMode);
        if (this.xoTransaction != null) {
            this.xoTransaction.registerDefaultSynchronization(new CacheSynchronization<Entity, Relation>(this.cacheSynchronizationService, this.entityCache, this.relationCache));
        }
    }

    public MetadataProvider<EntityMetadata, EntityDiscriminator, RelationMetadata, RelationDiscriminator> getMetadataProvider() {
        return this.metadataProvider;
    }

    public PluginRepositoryManager getPluginRepositoryManager() {
        return this.pluginRepositoryManager;
    }

    public AbstractInstanceManager<EntityId, Entity> getEntityInstanceManager() {
        return this.entityInstanceManager;
    }

    public AbstractInstanceManager<RelationId, Relation> getRelationInstanceManager() {
        return this.relationInstanceManager;
    }

    public InstanceListenerService getInstanceListenerService() {
        return this.instanceListenerService;
    }

    public TransactionalCache<EntityId> getEntityCache() {
        return this.entityCache;
    }

    public TransactionalCache<RelationId> getRelationCache() {
        return this.relationCache;
    }

    public InstanceValidationService getInstanceValidationService() {
        return this.instanceValidationService;
    }

    public CacheSynchronizationService<Entity, Relation> getCacheSynchronizationService() {
        return this.cacheSynchronizationService;
    }

    public XOTransaction getXOTransaction() {
        return this.xoTransaction;
    }

    public EntityPropertyManager<Entity, Relation, PropertyMetadata> getEntityPropertyManager() {
        return this.entityPropertyManager;
    }

    public RelationPropertyManager<Entity, Relation> getRelationPropertyManager() {
        return this.relationPropertyManager;
    }

    public InterceptorFactory getInterceptorFactory() {
        return this.interceptorFactory;
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public DatastoreSession<EntityId, Entity, EntityMetadata, EntityDiscriminator, RelationId, Relation, RelationMetadata, RelationDiscriminator, PropertyMetadata> getDatastoreSession() {
        return this.datastoreSession;
    }
}

