/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.sonar.sonarrules.rule;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.AggregationVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSetBuilder;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.impl.XmlRuleSetReader;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.impl.PluginConfigurationReaderImpl;
import com.buschmais.jqassistant.core.plugin.impl.RulePluginRepositoryImpl;
import com.buschmais.jqassistant.sonar.plugin.sensor.JQAssistantRuleType;
import com.buschmais.jqassistant.sonar.sonarrules.rule.ConceptTemplateRule;
import com.buschmais.jqassistant.sonar.sonarrules.rule.ConstraintTemplateRule;
import com.buschmais.jqassistant.sonar.sonarrules.rule.RuleParameter;
import java.util.List;
import java.util.Locale;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;

public final class JQAssistantRuleRepository
implements RulesDefinition {
    public static final Class[] RULE_CLASSES = new Class[]{ConceptTemplateRule.class, ConstraintTemplateRule.class};

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository newRepository = context.createRepository("jqassistant", "java");
        newRepository.setName("jQAssistant");
        RulesDefinitionAnnotationLoader annotationRuleParser = new RulesDefinitionAnnotationLoader();
        annotationRuleParser.load((RulesDefinition.NewExtendedRepository)newRepository, RULE_CLASSES);
        for (RulesDefinition.NewRule rule : newRepository.rules()) {
            rule.setTemplate(true);
        }
        this.createRules(newRepository);
        newRepository.done();
    }

    public void createRules(RulesDefinition.NewRepository newRepository) {
        RulePluginRepositoryImpl rulePluginRepository;
        PluginConfigurationReaderImpl pluginConfigurationReader = new PluginConfigurationReaderImpl(JQAssistantRuleRepository.class.getClassLoader());
        try {
            rulePluginRepository = new RulePluginRepositoryImpl((PluginConfigurationReader)pluginConfigurationReader);
        }
        catch (PluginRepositoryException e) {
            throw new IllegalStateException("Cannot read rules.", e);
        }
        List ruleSources = rulePluginRepository.getRuleSources();
        RuleSetBuilder ruleSetBuilder = RuleSetBuilder.newInstance();
        XmlRuleSetReader ruleSetReader = new XmlRuleSetReader();
        try {
            ruleSetReader.read(ruleSources, ruleSetBuilder);
        }
        catch (RuleException e) {
            throw new IllegalStateException("Cannot read rules", e);
        }
        RuleSet ruleSet = ruleSetBuilder.getRuleSet();
        for (Concept concept : ruleSet.getConceptBucket().getAll()) {
            this.createRule(newRepository, (ExecutableRule)concept, JQAssistantRuleType.Concept);
        }
        for (Constraint constraint : ruleSet.getConstraintBucket().getAll()) {
            this.createRule(newRepository, (ExecutableRule)constraint, JQAssistantRuleType.Constraint);
        }
    }

    private void createRule(RulesDefinition.NewRepository newRepository, ExecutableRule executableRule, JQAssistantRuleType ruleType) {
        Executable executable;
        RulesDefinition.NewRule rule = newRepository.createRule(executableRule.getId());
        rule.setName(executableRule.getId());
        rule.setInternalKey(executableRule.getId());
        rule.setSeverity(RulePriority.valueOf((String)executableRule.getSeverity().name()).name());
        rule.setMarkdownDescription(executableRule.getDescription());
        StringBuilder requiresConcepts = new StringBuilder();
        for (String requiredConcept : executableRule.getRequiresConcepts()) {
            if (requiresConcepts.length() > 0) {
                requiresConcepts.append(",");
            }
            requiresConcepts.append(requiredConcept);
        }
        this.createRuleParameter(rule, RuleParameter.Type, ruleType.name(), RuleParamType.STRING);
        rule.addTags(new String[]{ruleType.name().toLowerCase(Locale.ENGLISH)});
        if (requiresConcepts.length() > 0) {
            this.createRuleParameter(rule, RuleParameter.RequiresConcepts, requiresConcepts.toString(), RuleParamType.STRING);
        }
        String cypher = (executable = executableRule.getExecutable()) instanceof CypherExecutable ? ((CypherExecutable)executable).getStatement() : null;
        this.createRuleParameter(rule, RuleParameter.Cypher, cypher, RuleParamType.TEXT);
        Verification verification = executableRule.getVerification();
        if (verification instanceof AggregationVerification) {
            String aggregationColumn = ((AggregationVerification)verification).getColumn();
            this.createRuleParameter(rule, RuleParameter.Aggregation, Boolean.TRUE.toString(), RuleParamType.BOOLEAN);
            this.createRuleParameter(rule, RuleParameter.AggregationColumn, aggregationColumn, RuleParamType.STRING);
        }
    }

    private void createRuleParameter(RulesDefinition.NewRule rule, RuleParameter ruleParameterDefinition, String value, RuleParamType valueType) {
        RulesDefinition.NewParam parameter = rule.createParam(ruleParameterDefinition.getName());
        parameter.setDefaultValue(value);
        parameter.setType(valueType);
    }
}

