/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.TextOutputFormat;
import schemacrawler.tools.text.base.BaseFormatter;
import schemacrawler.tools.text.operation.DataJsonFormatter;
import schemacrawler.tools.text.operation.DataTextFormatter;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.operation.Query;
import schemacrawler.tools.traversal.DataTraversalHandler;
import sf.util.DatabaseUtility;

public final class OperationExecutable
extends BaseStagedExecutable {
    private static final Logger LOGGER = Logger.getLogger(OperationExecutable.class.getName());
    private OperationOptions operationOptions;

    public OperationExecutable(String command) {
        super(command);
    }

    public final OperationOptions getOperationOptions() {
        this.loadOperationOptions();
        return this.operationOptions;
    }

    public final void setOperationOptions(OperationOptions operationOptions) {
        this.operationOptions = operationOptions;
    }

    @Override
    public void executeOn(Catalog catalog, Connection connection) throws Exception {
        this.loadOperationOptions();
        this.checkOutputFormat();
        DataTraversalHandler handler = this.getDataTraversalHandler();
        Query query = this.getQuery();
        try (Statement statement = DatabaseUtility.createStatement(connection);){
            handler.begin();
            handler.handleInfoStart();
            handler.handle(catalog.getSchemaCrawlerInfo());
            handler.handle(catalog.getDatabaseInfo());
            handler.handle(catalog.getJdbcDriverInfo());
            handler.handleInfoEnd();
            if (query.isQueryOver()) {
                Collection<Table> tables = catalog.getTables();
                for (Table table : tables) {
                    String sql = query.getQueryForTable(table, this.operationOptions.isAlphabeticalSortForTableColumns());
                    LOGGER.log(Level.FINE, String.format("Executing query for table %s: %s", table.getFullName(), sql));
                    ResultSet results = DatabaseUtility.executeSql(statement, sql);
                    Throwable throwable = null;
                    try {
                        handler.handleData(table, results);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (results == null) continue;
                        if (throwable != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        results.close();
                    }
                }
            } else {
                String sql = query.getQuery();
                try (ResultSet results = DatabaseUtility.executeSql(statement, sql);){
                    handler.handleData(query, results);
                }
            }
            handler.end();
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Cannot perform operation", e);
        }
    }

    private void checkOutputFormat() {
        if (!this.outputOptions.hasOutputFormat()) {
            LOGGER.log(Level.CONFIG, "Unknown output format: " + this.outputOptions.getOutputFormatValue());
        }
    }

    private DataTraversalHandler getDataTraversalHandler() throws SchemaCrawlerException {
        Operation operation = this.getOperation();
        OperationOptions operationOptions = this.getOperationOptions();
        OutputFormat outputFormat = this.outputOptions.getOutputFormat();
        BaseFormatter formatter = outputFormat == TextOutputFormat.json ? new DataJsonFormatter(operation, operationOptions, this.outputOptions) : new DataTextFormatter(operation, operationOptions, this.outputOptions);
        return formatter;
    }

    private Operation getOperation() {
        Operation operation = null;
        try {
            operation = Operation.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            operation = null;
        }
        return operation;
    }

    private Query getQuery() {
        Query query;
        Operation operation = this.getOperation();
        if (operation == null) {
            String queryName = this.command;
            String queryString = this.additionalConfiguration != null ? (String)this.additionalConfiguration.get(queryName) : null;
            query = new Query(queryName, queryString);
        } else {
            query = operation.getQuery();
        }
        return query;
    }

    private void loadOperationOptions() {
        if (this.operationOptions == null) {
            this.operationOptions = new OperationOptions(this.additionalConfiguration);
        }
    }
}

