/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.integration.graph;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.analysis.associations.CatalogWithAssociations;
import schemacrawler.tools.executable.BaseStagedExecutable;
import schemacrawler.tools.integration.graph.GraphOptions;
import schemacrawler.tools.integration.graph.GraphOutputFormat;
import schemacrawler.tools.integration.graph.GraphOutputOptions;
import schemacrawler.tools.integration.graph.ProcessExecutor;
import schemacrawler.tools.options.InfoLevel;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.schema.SchemaDotFormatter;
import schemacrawler.tools.text.schema.SchemaTextDetailType;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.tools.traversal.SchemaTraverser;
import sf.util.Utility;

public final class GraphExecutable
extends BaseStagedExecutable {
    static final String COMMAND = "graph";
    private GraphOptions graphOptions;
    private static final Logger LOGGER = Logger.getLogger(GraphExecutable.class.getName());

    public GraphExecutable() {
        super(COMMAND);
    }

    public GraphExecutable(String command) {
        super(command);
    }

    @Override
    public void executeOn(Catalog db, Connection connection) throws Exception {
        InfoLevel infoLevel;
        try {
            infoLevel = InfoLevel.valueOf(this.schemaCrawlerOptions.getSchemaInfoLevel().getTag());
        }
        catch (Exception e) {
            infoLevel = InfoLevel.unknown;
        }
        Catalog catalog = infoLevel == InfoLevel.maximum ? new CatalogWithAssociations(db) : db;
        File dotFile = File.createTempFile("schemacrawler.", ".dot");
        SchemaTraversalHandler formatter = this.getSchemaTraversalHandler(dotFile);
        SchemaTraverser traverser = new SchemaTraverser();
        traverser.setCatalog(catalog);
        traverser.setHandler(formatter);
        traverser.traverse();
        GraphOptions graphOptions = this.getGraphOptions();
        GraphOutputOptions graphOutputOptions = new GraphOutputOptions(this.outputOptions);
        try {
            this.generateDiagram(graphOptions, graphOutputOptions, dotFile);
        }
        catch (Exception e) {
            System.out.println(Utility.readResourceFully("/dot.error.txt"));
            throw e;
        }
    }

    public final GraphOptions getGraphOptions() {
        GraphOptions graphOptions = this.graphOptions == null ? new GraphOptions(this.additionalConfiguration) : this.graphOptions;
        return graphOptions;
    }

    public final void setGraphOptions(GraphOptions graphOptions) {
        this.graphOptions = graphOptions;
    }

    private List<String> createDiagramCommand(GraphOptions graphOptions, GraphOutputOptions graphOutputOptions, File dotFile) {
        ArrayList<String> command = new ArrayList<String>();
        command.add("dot");
        command.addAll(graphOptions.getGraphVizOpts());
        command.add("-T");
        command.add(graphOutputOptions.getOutputFormat().getFormat());
        command.add("-o");
        command.add(graphOutputOptions.getDiagramFile().getAbsolutePath());
        command.add(dotFile.getAbsolutePath());
        Iterator iterator = command.iterator();
        while (iterator.hasNext()) {
            if (!Utility.isBlank((String)iterator.next())) continue;
            iterator.remove();
        }
        return command;
    }

    private void generateDiagram(GraphOptions graphOptions, GraphOutputOptions graphOutputOptions, File dotFile) throws IOException {
        if (graphOutputOptions.getOutputFormat() == GraphOutputFormat.scdot) {
            Files.copy(dotFile.toPath(), graphOutputOptions.getDiagramFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            return;
        }
        List<String> command = this.createDiagramCommand(graphOptions, graphOutputOptions, dotFile);
        ProcessExecutor processExecutor = new ProcessExecutor(command);
        int exitCode = processExecutor.execute();
        String processOutput = processExecutor.getProcessOutput();
        if (!Utility.isBlank(processOutput)) {
            LOGGER.log(Level.INFO, processOutput);
        }
        String processError = processExecutor.getProcessError();
        if (exitCode != 0) {
            throw new IOException(String.format("Process returned exit code %d%n%s", exitCode, processError));
        }
        if (!Utility.isBlank(processError)) {
            LOGGER.log(Level.WARNING, processError);
        }
    }

    private SchemaTextDetailType getSchemaTextDetailType() {
        SchemaTextDetailType schemaTextDetailType;
        try {
            schemaTextDetailType = SchemaTextDetailType.valueOf(this.command);
        }
        catch (IllegalArgumentException e) {
            schemaTextDetailType = null;
        }
        return schemaTextDetailType;
    }

    private SchemaTraversalHandler getSchemaTraversalHandler(File dotFile) throws SchemaCrawlerException {
        GraphOptions graphOptions = this.getGraphOptions();
        SchemaTextDetailType schemaTextDetailType = this.getSchemaTextDetailType();
        if (schemaTextDetailType == null) {
            schemaTextDetailType = graphOptions.getSchemaTextDetailType();
        }
        SchemaDotFormatter formatter = new SchemaDotFormatter(schemaTextDetailType, graphOptions, new OutputOptions("dot", dotFile));
        return formatter;
    }
}

