/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.options.HelpOptions;
import sf.util.Utility;

public final class SchemaCrawlerHelpCommandLine
implements CommandLine {
    private final String command;
    private final boolean showVersionOnly;
    private final HelpOptions helpOptions;

    private static void showHelp(String helpResource) {
        if (Utility.isBlank(helpResource) || SchemaCrawlerHelpCommandLine.class.getResource(helpResource) == null) {
            return;
        }
        String helpText = Utility.readResourceFully(helpResource);
        System.out.println(helpText);
    }

    public SchemaCrawlerHelpCommandLine(String[] args, HelpOptions helpOptions, boolean showVersionOnly) throws SchemaCrawlerException {
        if (args == null) {
            throw new IllegalArgumentException("No command line arguments provided");
        }
        if (helpOptions == null) {
            throw new SchemaCrawlerException("No help options provided");
        }
        this.helpOptions = helpOptions;
        this.showVersionOnly = showVersionOnly;
        String command = null;
        if (args.length != 0) {
            CommandParser commandParser = new CommandParser();
            commandParser.parse(args);
            if (commandParser.hasOptions()) {
                command = commandParser.getOptions().toString();
            }
        }
        this.command = command;
    }

    @Override
    public void execute() throws SchemaCrawlerException {
        CommandRegistry commandRegistry = new CommandRegistry();
        if (this.command != null && !commandRegistry.hasCommand(this.command)) {
            throw new SchemaCrawlerException("Unknown command, " + this.command);
        }
        System.out.println(this.helpOptions.getTitle());
        SchemaCrawlerHelpCommandLine.showHelp("/help/SchemaCrawler.txt");
        System.out.println();
        if (this.showVersionOnly) {
            System.exit(0);
        }
        SchemaCrawlerHelpCommandLine.showHelp(this.helpOptions.getHelpResource());
        SchemaCrawlerHelpCommandLine.showHelp("/help/SchemaCrawlerOptions.txt");
        SchemaCrawlerHelpCommandLine.showHelp("/help/Config.txt");
        SchemaCrawlerHelpCommandLine.showHelp("/help/ApplicationOptions.txt");
        if (this.command == null) {
            SchemaCrawlerHelpCommandLine.showHelp("/help/Command.txt");
            System.out.println("  Available commands are: ");
            for (String availableCommand : commandRegistry.lookupAvailableCommands()) {
                System.out.println("  " + availableCommand);
            }
        } else {
            String helpResource = commandRegistry.getHelpResource(this.command);
            SchemaCrawlerHelpCommandLine.showHelp(helpResource);
        }
        System.exit(0);
    }

    public final String getCommand() {
        return this.command;
    }
}

