/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.analysis.associations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.schemacrawler.BaseCatalogDecorator;
import schemacrawler.tools.analysis.associations.WeakAssociationsAnalyzer;

public final class CatalogWithAssociations
extends BaseCatalogDecorator {
    private static final long serialVersionUID = -3953296149824921463L;
    private static final String WEAK_ASSOCIATIONS_KEY = "schemacrawler.weak_associations";
    private final Collection<ColumnReference> weakAssociations;

    public static final Collection<ColumnReference> getWeakAssociations(Table table) {
        if (table == null) {
            return null;
        }
        SortedSet weakAssociations = table.getAttribute(WEAK_ASSOCIATIONS_KEY, new TreeSet());
        ArrayList<ColumnReference> weakAssociationsList = new ArrayList<ColumnReference>(weakAssociations);
        Collections.sort(weakAssociationsList);
        return weakAssociationsList;
    }

    static void addWeakAssociationToTable(TableReference table, ColumnReference weakAssociation) {
        if (table != null && weakAssociation != null) {
            SortedSet tableWeakAssociations = table.getAttribute(WEAK_ASSOCIATIONS_KEY, new TreeSet());
            tableWeakAssociations.add(weakAssociation);
            table.setAttribute(WEAK_ASSOCIATIONS_KEY, tableWeakAssociations);
        }
    }

    public CatalogWithAssociations(Catalog catalog) {
        super(catalog);
        ArrayList<Table> allTables = new ArrayList<Table>(catalog.getTables());
        WeakAssociationsAnalyzer weakAssociationsAnalyzer = new WeakAssociationsAnalyzer(allTables);
        this.weakAssociations = weakAssociationsAnalyzer.analyzeTables();
    }

    public Collection<ColumnReference> getWeakAssociations() {
        return this.weakAssociations;
    }
}

