/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import schemacrawler.crawl.AbstractNamedObject;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Privilege;
import sf.util.Utility;

final class MutablePrivilege<P extends DatabaseObject>
extends AbstractNamedObject
implements Privilege<P> {
    private final P parent;
    private final Set<Privilege.Grant> grants = new HashSet<Privilege.Grant>();
    private static final long serialVersionUID = -1117664231494271886L;

    MutablePrivilege(P parent, String name) {
        super(name);
        this.parent = parent;
    }

    @Override
    public Collection<Privilege.Grant> getGrants() {
        ArrayList<Privilege.Grant> values = new ArrayList<Privilege.Grant>(this.grants);
        Collections.sort(values);
        return values;
    }

    @Override
    public P getParent() {
        return this.parent;
    }

    void addGrant(String grantor, String grantee, boolean isGrantable) {
        if (!Utility.isBlank(grantor) && !Utility.isBlank(grantee)) {
            this.grants.add(new PrivilegeGrant(grantor, grantee, isGrantable));
        }
    }

    private final class PrivilegeGrant
    implements Privilege.Grant {
        private static final long serialVersionUID = 356151825191631484L;
        private final String grantor;
        private final String grantee;
        private final boolean isGrantable;

        PrivilegeGrant(String grantor, String grantee, boolean isGrantable) {
            this.grantor = grantor;
            this.grantee = grantee;
            this.isGrantable = isGrantable;
        }

        @Override
        public int compareTo(Privilege.Grant otherGrant) {
            int compare = 0;
            if (compare == 0) {
                compare = this.grantor.compareTo(otherGrant.getGrantor());
            }
            if (compare == 0) {
                compare = this.grantee.compareTo(otherGrant.getGrantee());
            }
            return compare;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrivilegeGrant other = (PrivilegeGrant)obj;
            if (!((AbstractNamedObject)this.getParent()).equals(other.getParent())) {
                return false;
            }
            if (this.grantee == null ? other.grantee != null : !this.grantee.equals(other.grantee)) {
                return false;
            }
            if (this.grantor == null ? other.grantor != null : !this.grantor.equals(other.grantor)) {
                return false;
            }
            return this.isGrantable == other.isGrantable;
        }

        @Override
        public String getGrantee() {
            return this.grantee;
        }

        @Override
        public String getGrantor() {
            return this.grantor;
        }

        @Override
        public MutablePrivilege<P> getParent() {
            return MutablePrivilege.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + ((AbstractNamedObject)this.getParent()).hashCode();
            result = 31 * result + (this.grantee == null ? 0 : this.grantee.hashCode());
            result = 31 * result + (this.grantor == null ? 0 : this.grantor.hashCode());
            result = 31 * result + (this.isGrantable ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean isGrantable() {
            return this.isGrantable;
        }
    }
}

