/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.common.report;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.visitor.CollectRulesVisitor;
import com.buschmais.jqassistant.core.analysis.impl.RuleExecutor;
import com.buschmais.jqassistant.core.analysis.impl.RuleVisitor;
import java.util.Set;
import org.slf4j.Logger;

public final class RuleHelper {
    public static final String LOG_LINE_PREFIX = "  \"";
    private Logger logger;

    public RuleHelper(Logger log) {
        this.logger = log;
    }

    public void printRuleSet(RuleSet ruleSet) throws AnalysisException {
        RuleSelection ruleSelection = RuleSelection.Builder.allOf((RuleSet)ruleSet);
        this.printRuleSet(ruleSet, ruleSelection);
    }

    public void printRuleSet(RuleSet ruleSet, RuleSelection ruleSelection) throws AnalysisException {
        CollectRulesVisitor visitor = this.getAllRules(ruleSet, ruleSelection);
        this.printValidRules(visitor);
        this.printMissingRules(visitor);
    }

    private void printValidRules(CollectRulesVisitor visitor) {
        this.logger.info("Groups [" + visitor.getGroups().size() + "]");
        for (Group group : visitor.getGroups()) {
            this.logger.info(LOG_LINE_PREFIX + group.getId() + "\"");
        }
        this.logger.info("Constraints [" + visitor.getConstraints().size() + "]");
        for (Constraint constraint : visitor.getConstraints().keySet()) {
            this.logger.info(LOG_LINE_PREFIX + constraint.getId() + "\" - " + constraint.getDescription());
        }
        this.logger.info("Concepts [" + visitor.getConcepts().size() + "]");
        for (Concept concept : visitor.getConcepts().keySet()) {
            this.logger.info(LOG_LINE_PREFIX + concept.getId() + "\" - " + concept.getDescription());
        }
    }

    private CollectRulesVisitor getAllRules(RuleSet ruleSet, RuleSelection ruleSelection) throws AnalysisException {
        CollectRulesVisitor visitor = new CollectRulesVisitor();
        RuleExecutor executor = new RuleExecutor((RuleVisitor)visitor);
        executor.execute(ruleSet, ruleSelection);
        return visitor;
    }

    private boolean printMissingRules(CollectRulesVisitor visitor) {
        Set missingGroups;
        Set missingConstraints;
        Set missingConcepts = visitor.getMissingConcepts();
        if (!missingConcepts.isEmpty()) {
            this.logger.info("Missing concepts [" + missingConcepts.size() + "]");
            for (Object missingConcept : missingConcepts) {
                this.logger.warn(LOG_LINE_PREFIX + (String)missingConcept);
            }
        }
        if (!(missingConstraints = visitor.getMissingConstraints()).isEmpty()) {
            this.logger.info("Missing constraints [" + missingConstraints.size() + "]");
            for (String missingConstraint : missingConstraints) {
                this.logger.warn(LOG_LINE_PREFIX + missingConstraint);
            }
        }
        if (!(missingGroups = visitor.getMissingGroups()).isEmpty()) {
            this.logger.info("Missing groups [" + missingGroups.size() + "]");
            for (String missingGroup : missingGroups) {
                this.logger.warn(LOG_LINE_PREFIX + missingGroup);
            }
        }
        return missingConcepts.isEmpty() && missingConstraints.isEmpty() && missingGroups.isEmpty();
    }
}

