/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.impl.scanner.visitor;

import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeCache;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.AbstractTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.DependentTypeSignatureVisitor;
import com.buschmais.jqassistant.plugin.java.impl.scanner.visitor.VisitorHelper;
import org.objectweb.asm.signature.SignatureVisitor;

public class ClassSignatureVisitor
extends SignatureVisitor {
    private TypeCache.CachedType<? extends ClassFileDescriptor> cachedType;
    private VisitorHelper visitorHelper;

    protected ClassSignatureVisitor(TypeCache.CachedType<? extends ClassFileDescriptor> cachedType, VisitorHelper visitorHelper) {
        super(327680);
        this.cachedType = cachedType;
        this.visitorHelper = visitorHelper;
    }

    public SignatureVisitor visitClassBound() {
        return new DependentTypeSignatureVisitor(this.cachedType, this.visitorHelper);
    }

    public SignatureVisitor visitInterfaceBound() {
        return new DependentTypeSignatureVisitor(this.cachedType, this.visitorHelper);
    }

    public SignatureVisitor visitSuperclass() {
        return new AbstractTypeSignatureVisitor<TypeDescriptor>(this.cachedType, this.visitorHelper){

            public SignatureVisitor visitArrayType() {
                return new DependentTypeSignatureVisitor(ClassSignatureVisitor.this.cachedType, ClassSignatureVisitor.this.visitorHelper);
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new DependentTypeSignatureVisitor(ClassSignatureVisitor.this.cachedType, ClassSignatureVisitor.this.visitorHelper);
            }

            @Override
            public void visitEnd(TypeDescriptor resolvedTypeDescriptor) {
                ((ClassFileDescriptor)ClassSignatureVisitor.this.cachedType.getTypeDescriptor()).setSuperClass(resolvedTypeDescriptor);
            }
        };
    }

    public SignatureVisitor visitInterface() {
        return new AbstractTypeSignatureVisitor<TypeDescriptor>(this.cachedType, this.visitorHelper){

            public SignatureVisitor visitArrayType() {
                return new DependentTypeSignatureVisitor(ClassSignatureVisitor.this.cachedType, ClassSignatureVisitor.this.visitorHelper);
            }

            public SignatureVisitor visitTypeArgument(char wildcard) {
                return new DependentTypeSignatureVisitor(ClassSignatureVisitor.this.cachedType, ClassSignatureVisitor.this.visitorHelper);
            }

            @Override
            public void visitEnd(TypeDescriptor resolvedTypeDescriptor) {
                ((ClassFileDescriptor)ClassSignatureVisitor.this.cachedType.getTypeDescriptor()).getInterfaces().add(resolvedTypeDescriptor);
            }
        };
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        throw new UnsupportedOperationException("Method is not implemented.");
    }
}

