/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.java.api.model.FieldDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MethodDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDependsOnDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.HashMap;
import java.util.Map;

public class TypeCache {
    private Cache<String, CachedType> lruCache = CacheBuilder.newBuilder().maximumSize(8192L).removalListener((RemovalListener)new RemovalListener<String, CachedType>(){

        public void onRemoval(RemovalNotification<String, CachedType> notification) {
            if (RemovalCause.SIZE.equals((Object)notification.getCause())) {
                TypeCache.this.softCache.put(notification.getKey(), notification.getValue());
            }
        }
    }).build();
    private Cache<String, CachedType> softCache = CacheBuilder.newBuilder().softValues().build();

    TypeCache() {
    }

    public CachedType get(String fullQualifiedName) {
        CachedType cachedType = (CachedType)this.lruCache.getIfPresent((Object)fullQualifiedName);
        if (cachedType != null) {
            return cachedType;
        }
        cachedType = (CachedType)this.softCache.getIfPresent((Object)fullQualifiedName);
        if (cachedType != null) {
            this.lruCache.put((Object)fullQualifiedName, (Object)cachedType);
        }
        return cachedType;
    }

    public void put(String fullQualifiedName, CachedType cachedType) {
        this.lruCache.put((Object)fullQualifiedName, (Object)cachedType);
    }

    public static class CachedType<T extends TypeDescriptor> {
        private T typeDescriptor;
        private Map<String, MemberDescriptor> members = null;
        private Map<String, TypeDependsOnDescriptor> dependencies = null;

        public CachedType(T typeDescriptor) {
            this.typeDescriptor = typeDescriptor;
        }

        public T getTypeDescriptor() {
            return this.typeDescriptor;
        }

        public FieldDescriptor getField(String signature) {
            return (FieldDescriptor)this.getMembers().get(signature);
        }

        public MethodDescriptor getMethod(String signature) {
            return (MethodDescriptor)this.getMembers().get(signature);
        }

        public void addMember(String signature, MemberDescriptor member) {
            this.typeDescriptor.getDeclaredMembers().add(member);
            this.getMembers().put(signature, member);
        }

        public TypeDependsOnDescriptor getDependency(String fullQualifiedName) {
            return this.getDependencies().get(fullQualifiedName);
        }

        public void addDependency(String fullQualifiedName, TypeDependsOnDescriptor dependency) {
            this.getDependencies().put(fullQualifiedName, dependency);
        }

        private Map<String, MemberDescriptor> getMembers() {
            if (this.members == null) {
                this.members = new HashMap<String, MemberDescriptor>();
                for (Descriptor descriptor : this.typeDescriptor.getDeclaredMembers()) {
                    if (!(descriptor instanceof MemberDescriptor)) continue;
                    MemberDescriptor memberDescriptor = (MemberDescriptor)descriptor;
                    this.members.put(memberDescriptor.getSignature(), memberDescriptor);
                }
            }
            return this.members;
        }

        private Map<String, TypeDependsOnDescriptor> getDependencies() {
            if (this.dependencies == null) {
                this.dependencies = new HashMap<String, TypeDependsOnDescriptor>();
                for (TypeDependsOnDescriptor dependency : this.typeDescriptor.getDependencies()) {
                    this.dependencies.put(dependency.getDependency().getFullQualifiedName(), dependency);
                }
            }
            return this.dependencies;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CachedType)) {
                return false;
            }
            CachedType that = (CachedType)o;
            return this.typeDescriptor.equals(that.typeDescriptor);
        }

        public int hashCode() {
            return this.typeDescriptor.hashCode();
        }
    }
}

