/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.AbstractTypeResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractArtifactScopedTypeResolver
extends AbstractTypeResolver {
    private JavaArtifactFileDescriptor artifact;
    private Map<String, TypeDescriptor> artifactTypes = new HashMap<String, TypeDescriptor>();

    protected AbstractArtifactScopedTypeResolver(JavaArtifactFileDescriptor artifact) {
        this.artifact = artifact;
        this.addToCache(artifact.getContains());
        this.addToCache(artifact.getRequires());
    }

    private void addToCache(List<FileDescriptor> fileDescriptors) {
        for (FileDescriptor fileDescriptor : fileDescriptors) {
            if (!(fileDescriptor instanceof TypeDescriptor)) continue;
            TypeDescriptor typeDescriptor = (TypeDescriptor)fileDescriptor;
            this.artifactTypes.put(typeDescriptor.getFullQualifiedName(), typeDescriptor);
        }
    }

    protected JavaArtifactFileDescriptor getArtifact() {
        return this.artifact;
    }

    @Override
    protected TypeDescriptor findInArtifact(String fullQualifiedName, ScannerContext context) {
        return this.artifactTypes.get(fullQualifiedName);
    }

    @Override
    protected void addContainedType(String fqn, TypeDescriptor typeDescriptor) {
        this.artifactTypes.put(fqn, typeDescriptor);
    }

    @Override
    protected void addRequiredType(String fqn, TypeDescriptor typeDescriptor) {
        this.artifactTypes.put(fqn, typeDescriptor);
    }

    @Override
    protected <T extends TypeDescriptor> void removeRequiredType(String fqn, T typeDescriptor) {
    }
}

