/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.java.api.report;

import com.buschmais.jqassistant.core.report.api.Language;
import com.buschmais.jqassistant.core.report.api.LanguageElement;
import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ClassFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.InvokesDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.MemberDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.PackageDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.ReadsDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.TypeDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.WritesDescriptor;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Language
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface Java {
    public JavaLanguageElement value();

    public static enum JavaLanguageElement implements LanguageElement
    {
        Package{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new SourceProvider<PackageDescriptor>(){

                    public String getName(PackageDescriptor descriptor) {
                        return descriptor.getFullQualifiedName();
                    }

                    public String getSourceFile(PackageDescriptor descriptor) {
                        return descriptor.getFileName();
                    }

                    public Integer getLineNumber(PackageDescriptor descriptor) {
                        return null;
                    }
                };
            }
        }
        ,
        Type{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new SourceProvider<ClassFileDescriptor>(){

                    public String getName(ClassFileDescriptor descriptor) {
                        return descriptor.getFullQualifiedName();
                    }

                    public String getSourceFile(ClassFileDescriptor descriptor) {
                        return descriptor.getFileName();
                    }

                    public Integer getLineNumber(ClassFileDescriptor descriptor) {
                        return null;
                    }
                };
            }
        }
        ,
        Field{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new MemberSourceProvider();
            }
        }
        ,
        ReadField{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new SourceProvider<ReadsDescriptor>(){

                    public String getName(ReadsDescriptor descriptor) {
                        return new MemberSourceProvider().getName(descriptor.getMethod()) + ", line " + descriptor.getLineNumber();
                    }

                    public String getSourceFile(ReadsDescriptor descriptor) {
                        TypeDescriptor declaringType = descriptor.getMethod().getDeclaringType();
                        return declaringType instanceof ClassFileDescriptor ? ((FileDescriptor)descriptor).getFileName() : null;
                    }

                    public Integer getLineNumber(ReadsDescriptor descriptor) {
                        return descriptor.getLineNumber();
                    }
                };
            }
        }
        ,
        WriteField{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new SourceProvider<WritesDescriptor>(){

                    public String getName(WritesDescriptor descriptor) {
                        return new MemberSourceProvider().getName(descriptor.getMethod()) + ", line " + descriptor.getLineNumber();
                    }

                    public String getSourceFile(WritesDescriptor descriptor) {
                        TypeDescriptor declaringType = descriptor.getMethod().getDeclaringType();
                        return declaringType instanceof ClassFileDescriptor ? ((FileDescriptor)declaringType).getFileName() : null;
                    }

                    public Integer getLineNumber(WritesDescriptor descriptor) {
                        return descriptor.getLineNumber();
                    }
                };
            }
        }
        ,
        Method{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new MemberSourceProvider();
            }
        }
        ,
        Constructor{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new MemberSourceProvider();
            }
        }
        ,
        MethodInvocation{

            public SourceProvider<? extends Descriptor> getSourceProvider() {
                return new SourceProvider<InvokesDescriptor>(){

                    public String getName(InvokesDescriptor descriptor) {
                        return new MemberSourceProvider().getName(descriptor.getInvokingMethod()) + ", line " + descriptor.getLineNumber();
                    }

                    public String getSourceFile(InvokesDescriptor descriptor) {
                        TypeDescriptor declaringType = descriptor.getInvokingMethod().getDeclaringType();
                        return declaringType instanceof ClassFileDescriptor ? ((FileDescriptor)declaringType).getFileName() : null;
                    }

                    public Integer getLineNumber(InvokesDescriptor descriptor) {
                        return descriptor.getLineNumber();
                    }
                };
            }
        };


        public String getLanguage() {
            return "Java";
        }

        private static String getFileName(Descriptor descriptor) {
            return descriptor instanceof FileDescriptor ? ((FileDescriptor)descriptor).getFileName() : null;
        }

        private static class MemberSourceProvider
        implements SourceProvider<MemberDescriptor> {
            private MemberSourceProvider() {
            }

            public String getName(MemberDescriptor descriptor) {
                return descriptor.getDeclaringType().getFullQualifiedName() + "#" + descriptor.getSignature();
            }

            public String getSourceFile(MemberDescriptor descriptor) {
                TypeDescriptor declaringType = descriptor.getDeclaringType();
                return declaringType instanceof ClassFileDescriptor ? ((FileDescriptor)declaringType).getFileName() : null;
            }

            public Integer getLineNumber(MemberDescriptor descriptor) {
                return null;
            }
        }
    }
}

