/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.scanner.impl;

import com.buschmais.jqassistant.core.scanner.api.DefaultScope;
import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerConfiguration;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.xo.spi.reflection.DependencyResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerImpl
implements Scanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScannerImpl.class);
    private final ScannerConfiguration configuration;
    private final ScannerContext scannerContext;
    private final Map<String, ScannerPlugin<?, ?>> scannerPlugins;
    private final Map<Class<?>, List<ScannerPlugin<?, ?>>> scannerPluginsPerType = new HashMap();
    private final Map<String, Scope> scopes;
    private final Map<Object, Set<ScannerPlugin<?, ?>>> pipelines = new IdentityHashMap();

    public ScannerImpl(ScannerConfiguration configuration, ScannerContext scannerContext, Map<String, ScannerPlugin<?, ?>> scannerPlugins, Map<String, Scope> scopes) {
        this.configuration = configuration;
        this.scannerContext = scannerContext;
        this.scannerPlugins = scannerPlugins;
        this.scopes = scopes;
        this.scannerContext.push(Scope.class, null);
    }

    @Override
    public <I, D extends Descriptor> D scan(I item, String path, Scope scope) {
        return this.scan(item, null, path, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <I, D extends Descriptor> D scan(I item, D descriptor, String path, Scope scope) {
        boolean pipelineCreated;
        Set<ScannerPlugin<?, ?>> pipeline = this.pipelines.get(item);
        if (pipeline == null) {
            pipeline = new LinkedHashSet();
            this.pipelines.put(item, pipeline);
            pipelineCreated = true;
        } else {
            pipelineCreated = false;
        }
        Class<?> itemClass = item.getClass();
        Class<?> type = null;
        for (ScannerPlugin<?, ?> scannerPlugin : this.getScannerPluginsForType(itemClass)) {
            ScannerPlugin<?, ?> selectedPlugin = scannerPlugin;
            if (pipeline.contains(selectedPlugin) || !this.accepts(selectedPlugin, item, path, scope) || !this.satisfies(selectedPlugin, descriptor)) continue;
            pipeline.add(selectedPlugin);
            this.pushDesriptor(type, descriptor);
            this.enterScope(scope);
            Object newDescriptor = null;
            try {
                newDescriptor = selectedPlugin.scan(item, path, scope, this);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot scan item " + path, (Throwable)e);
            }
            catch (RuntimeException e) {
                String message = "Unexpected problem encountered while scanning: item='" + item + "', path='" + path + "', scope='" + scope + "', pipeline='" + pipeline + "'. Please report this error including the full stacktrace (continueOnError=" + this.configuration.isContinueOnError() + ").";
                if (this.configuration.isContinueOnError()) {
                    LOGGER.error(message, (Throwable)e);
                    LOGGER.info("Continuing scan after error. NOTE: Data might be inconsistent.");
                    continue;
                }
                throw new IllegalStateException(message, e);
            }
            finally {
                this.leaveScope(scope);
                this.popDescriptor(type, descriptor);
                descriptor = newDescriptor;
                type = selectedPlugin.getDescriptorType();
            }
        }
        if (pipelineCreated) {
            this.pipelines.remove(item);
        }
        return descriptor;
    }

    private <I, D extends Descriptor> boolean satisfies(ScannerPlugin<I, D> selectedPlugin, D descriptor) {
        return !selectedPlugin.getClass().isAnnotationPresent(ScannerPlugin.Requires.class) || descriptor != null;
    }

    protected <I> boolean accepts(ScannerPlugin<I, ?> selectedPlugin, I item, String path, Scope scope) {
        boolean accepted = false;
        try {
            accepted = selectedPlugin.accepts(item, path, scope);
        }
        catch (IOException e) {
            LOGGER.error("Plugin " + selectedPlugin + " failed to check whether it can accept item " + path, (Throwable)e);
        }
        return accepted;
    }

    private <D extends Descriptor> void pushDesriptor(Class<D> type, D descriptor) {
        if (descriptor != null) {
            this.scannerContext.push(type, descriptor);
            this.scannerContext.setCurrentDescriptor(descriptor);
        }
    }

    private <D extends Descriptor> void popDescriptor(Class<D> type, D descriptor) {
        if (descriptor != null) {
            this.scannerContext.setCurrentDescriptor(null);
            this.scannerContext.pop(type);
        }
    }

    @Override
    public ScannerContext getContext() {
        return this.scannerContext;
    }

    @Override
    public Scope resolveScope(String name) {
        if (name == null) {
            return DefaultScope.NONE;
        }
        Scope scope = this.scopes.get(name);
        if (scope == null) {
            LOGGER.warn("No scope found for name '" + name + "'.");
            scope = DefaultScope.NONE;
        }
        return scope;
    }

    private List<ScannerPlugin<?, ?>> getScannerPluginsForType(Class<?> type) {
        List plugins = this.scannerPluginsPerType.get(type);
        if (plugins == null) {
            LinkedList candidates = new LinkedList();
            final HashMap pluginsByDescriptor = new HashMap();
            for (ScannerPlugin<?, ?> scannerPlugin : this.scannerPlugins.values()) {
                Class<?> scannerPluginType = scannerPlugin.getType();
                if (!scannerPluginType.isAssignableFrom(type)) continue;
                Class<?> descriptorType = scannerPlugin.getDescriptorType();
                HashSet pluginsForDescriptorType = (HashSet)pluginsByDescriptor.get(descriptorType);
                if (pluginsForDescriptorType == null) {
                    pluginsForDescriptorType = new HashSet();
                    pluginsByDescriptor.put(descriptorType, pluginsForDescriptorType);
                }
                pluginsForDescriptorType.add(scannerPlugin);
                candidates.add(scannerPlugin);
            }
            plugins = DependencyResolver.newInstance(candidates, (DependencyResolver.DependencyProvider)new DependencyResolver.DependencyProvider<ScannerPlugin<?, ?>>(){

                public Set<ScannerPlugin<?, ?>> getDependencies(ScannerPlugin<?, ?> dependent) {
                    HashSet dependencies = new HashSet();
                    ScannerPlugin.Requires annotation = dependent.getClass().getAnnotation(ScannerPlugin.Requires.class);
                    if (annotation != null) {
                        for (Class<? extends Descriptor> descriptorType : annotation.value()) {
                            Set pluginsByDescriptorType = (Set)pluginsByDescriptor.get(descriptorType);
                            if (pluginsByDescriptorType == null) continue;
                            for (ScannerPlugin scannerPlugin : pluginsByDescriptorType) {
                                if (scannerPlugin.equals(dependent)) continue;
                                dependencies.add(scannerPlugin);
                            }
                        }
                    }
                    return dependencies;
                }
            }).resolve();
            this.scannerPluginsPerType.put(type, plugins);
        }
        return plugins;
    }

    private void enterScope(Scope newScope) {
        Scope oldScope = this.scannerContext.peekOrDefault(Scope.class, null);
        if (newScope != null && !newScope.equals(oldScope)) {
            newScope.onEnter(this.scannerContext);
        }
        this.scannerContext.push(Scope.class, newScope);
    }

    private void leaveScope(Scope newScope) {
        this.scannerContext.pop(Scope.class);
        Scope oldScope = this.scannerContext.peekOrDefault(Scope.class, null);
        if (newScope != null && !newScope.equals(oldScope)) {
            newScope.onLeave(this.scannerContext);
        }
    }
}

