/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.concurrent;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.concurrent.AsyncEvent;
import org.neo4j.concurrent.AsyncEventSender;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.function.Consumer;

public class AsyncEvents<T extends AsyncEvent>
implements AsyncEventSender<T>,
Runnable {
    private static final AtomicReferenceFieldUpdater<AsyncEvents, AsyncEvent> STACK = AtomicReferenceFieldUpdater.newUpdater(AsyncEvents.class, AsyncEvent.class, "stack");
    private static final Sentinel END_SENTINEL = new Sentinel("END");
    private static final Sentinel SHUTDOWN_SENTINEL = new Sentinel("SHUTDOWN");
    private final Consumer<T> eventConsumer;
    private final Monitor monitor;
    private final BinaryLatch startupLatch;
    private final BinaryLatch shutdownLatch;
    private volatile AsyncEvent stack;
    private volatile Thread backgroundThread;
    private volatile boolean shutdown;

    public AsyncEvents(Consumer<T> eventConsumer, Monitor monitor) {
        this.eventConsumer = eventConsumer;
        this.monitor = monitor;
        this.startupLatch = new BinaryLatch();
        this.shutdownLatch = new BinaryLatch();
        this.stack = END_SENTINEL;
    }

    @Override
    public void send(T event) {
        AsyncEvent prev = STACK.getAndSet(this, (AsyncEvent)event);
        assert (prev != null);
        ((AsyncEvent)event).next = prev;
        if (prev == END_SENTINEL) {
            LockSupport.unpark(this.backgroundThread);
        } else if (prev == SHUTDOWN_SENTINEL) {
            AsyncEvent events = STACK.getAndSet(this, SHUTDOWN_SENTINEL);
            this.process(events);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (this.backgroundThread == null) : "A thread is already running " + this.backgroundThread;
        this.backgroundThread = Thread.currentThread();
        this.startupLatch.release();
        try {
            AsyncEvent events;
            do {
                events = STACK.getAndSet(this, END_SENTINEL);
                this.process(events);
                if (this.stack != END_SENTINEL || this.shutdown) continue;
                LockSupport.park(this);
            } while (!this.shutdown);
            events = STACK.getAndSet(this, SHUTDOWN_SENTINEL);
            this.process(events);
        }
        finally {
            this.backgroundThread = null;
            this.shutdownLatch.release();
        }
    }

    private void process(AsyncEvent events) {
        events = this.reverseAndStripEndMark(events);
        Consumer<T> consumer = this.eventConsumer;
        while (events != null) {
            AsyncEvent event = events;
            consumer.accept((Object)event);
            events = events.next;
        }
    }

    private AsyncEvent reverseAndStripEndMark(AsyncEvent events) {
        AsyncEvent result = null;
        long count = 0L;
        while (events != END_SENTINEL && events != SHUTDOWN_SENTINEL) {
            AsyncEvent next;
            while ((next = events.next) == null) {
            }
            events.next = result;
            result = events;
            events = next;
            ++count;
        }
        if (count > 0L) {
            this.monitor.eventCount(count);
        }
        return result;
    }

    public void shutdown() {
        assert (this.backgroundThread != null) : "Already shut down";
        this.shutdown = true;
        LockSupport.unpark(this.backgroundThread);
    }

    public void awaitStartup() {
        this.startupLatch.await();
    }

    public void awaitTermination() throws InterruptedException {
        this.shutdownLatch.await();
    }

    private static class Sentinel
    extends AsyncEvent {
        private final String str;

        Sentinel(String identifier) {
            this.str = "AsyncEvent/Sentinel[" + identifier + "]";
        }

        public String toString() {
            return this.str;
        }
    }

    public static interface Monitor {
        public static final Monitor NONE = new Monitor(){

            @Override
            public void eventCount(long count) {
            }
        };

        public void eventCount(long var1);
    }
}

