/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.yaml.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLDocumentDescriptor;
import com.buschmais.jqassistant.plugin.yaml.api.model.YAMLFileDescriptor;
import com.buschmais.jqassistant.plugin.yaml.impl.scanner.YAMLEmitter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public class YAMLFileScannerPlugin
extends AbstractScannerPlugin<FileResource, YAMLFileDescriptor> {
    public static final String YAML_FILE_EXTENSION = ".yaml";

    public boolean accepts(FileResource file, String path, Scope scope) throws IOException {
        return path.toLowerCase().endsWith(YAML_FILE_EXTENSION);
    }

    public YAMLFileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        Store store = context.getStore();
        Yaml yaml = new Yaml((BaseConstructor)new TagOverridingConstructor(), new Representer(), new DumperOptions(), (Resolver)new NonResolvingResolver());
        Representer representer = new Representer();
        DumperOptions options = new DumperOptions();
        FileDescriptor fileDescriptor = (FileDescriptor)context.peek(FileDescriptor.class);
        YAMLFileDescriptor yamlFileDescriptor = (YAMLFileDescriptor)store.addDescriptorType((Descriptor)fileDescriptor, YAMLFileDescriptor.class);
        try (InputStream in = item.createStream();){
            Iterable docs = yaml.loadAll(in);
            for (Object doc : docs) {
                Node node = representer.represent(doc);
                YAMLEmitter emitter = new YAMLEmitter(yamlFileDescriptor, scanner);
                Serializer serializer = new Serializer((Emitable)emitter, new Resolver(), options, null);
                serializer.open();
                serializer.serialize(node);
                serializer.close();
            }
            yamlFileDescriptor.setValid(true);
        }
        catch (RuntimeException rt) {
            yamlFileDescriptor.setValid(false);
            for (YAMLDocumentDescriptor documentDescriptor : yamlFileDescriptor.getDocuments()) {
                yamlFileDescriptor.getDocuments().remove(documentDescriptor);
            }
        }
        return yamlFileDescriptor;
    }

    class TagOverridingConstructor
    extends Constructor {
        private List<Tag> SUPPORTED_TAGS = Arrays.asList(Tag.YAML, Tag.MERGE, Tag.SET, Tag.PAIRS, Tag.OMAP, Tag.BINARY, Tag.INT, Tag.FLOAT, Tag.BOOL, Tag.NULL, Tag.STR, Tag.SEQ, Tag.MAP);

        TagOverridingConstructor() {
        }

        protected Object constructObject(Node node) {
            Tag tag = node.getTag();
            if (!this.SUPPORTED_TAGS.contains(tag)) {
                node.setTag(Tag.STR);
            }
            return super.constructObject(node);
        }
    }

    private static class NonResolvingResolver
    extends Resolver {
        private NonResolvingResolver() {
        }

        protected void addImplicitResolvers() {
        }
    }
}

