/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.PackUtils;
import org.jruby.util.TypeConverter;

public class Pack {
    private static final byte[] sSp10;
    private static final byte[] sNil10;
    private static final int IS_STAR = -1;
    private static final ASCIIEncoding ASCII;
    private static final USASCIIEncoding USASCII;
    private static final UTF8Encoding UTF8;
    private static final String NATIVE_CODES = "sSiIlL";
    private static final String MAPPED_CODES = "sSiIqQ";
    private static final char BE = '=';
    private static final char LE = '<';
    private static final String ENDIANESS_CODES;
    private static final String UNPACK_IGNORE_NULL_CODES = "cC";
    private static final String PACK_IGNORE_NULL_CODES = "cCiIlLnNqQsSvV";
    private static final String PACK_IGNORE_NULL_CODES_WITH_MODIFIERS = "lLsS";
    private static final String sTooFew = "too few arguments";
    private static final byte[] uu_table;
    private static final byte[] b64_table;
    private static final byte[] sHexDigits;
    private static final int[] b64_xtable;
    private static final Converter[] converters;
    private static final long[] utf8_limits;

    private static long num2quad(IRubyObject arg2) {
        if (arg2 == arg2.getRuntime().getNil()) {
            return 0L;
        }
        if (arg2 instanceof RubyBignum) {
            BigInteger big = ((RubyBignum)arg2).getValue();
            return big.longValue();
        }
        return RubyNumeric.num2long(arg2);
    }

    private static float obj2flt(Ruby runtime, IRubyObject o) {
        return (float)TypeConverter.toFloat(runtime, o).getDoubleValue();
    }

    private static double obj2dbl(Ruby runtime, IRubyObject o) {
        return TypeConverter.toFloat(runtime, o).getDoubleValue();
    }

    public static int unpackInt_i(ByteBuffer enc) {
        int value2 = Platform.BYTE_ORDER == 4321 ? Pack.decodeIntBigEndian(enc) : Pack.decodeIntLittleEndian(enc);
        return value2;
    }

    public static ByteList packInt_i(ByteList result2, int s2) {
        if (Platform.BYTE_ORDER == 4321) {
            Pack.encodeIntBigEndian(result2, s2);
        } else {
            Pack.encodeIntLittleEndian(result2, s2);
        }
        return result2;
    }

    public static void encodeUM(Ruby runtime, ByteList lCurElemString, int occurrences, boolean ignoreStar, char type2, ByteList result2) {
        if (occurrences == 0 && type2 == 'm' && !ignoreStar) {
            Pack.encodes(runtime, result2, lCurElemString.getUnsafeBytes(), lCurElemString.getBegin(), lCurElemString.length(), lCurElemString.length(), (byte)type2, false);
            return;
        }
        int n = occurrences = occurrences <= 2 ? 45 : occurrences / 3 * 3;
        if (lCurElemString.length() == 0) {
            return;
        }
        byte[] charsToEncode = lCurElemString.getUnsafeBytes();
        for (int i2 = 0; i2 < lCurElemString.length(); i2 += occurrences) {
            Pack.encodes(runtime, result2, charsToEncode, i2 + lCurElemString.getBegin(), lCurElemString.length() - i2, occurrences, (byte)type2, true);
        }
    }

    private static ByteList encodes(Ruby runtime, ByteList io2Append, byte[] charsToEncode, int startIndex, int length2, int charCount, byte encodingType, boolean tailLf) {
        byte lNextChar;
        byte lCurChar;
        byte lPadding;
        byte[] lTranslationTable;
        charCount = charCount < length2 ? charCount : length2;
        io2Append.ensure(charCount * 4 / 3 + 6);
        int i2 = startIndex;
        byte[] byArray = lTranslationTable = encodingType == 117 ? uu_table : b64_table;
        if (encodingType == 117) {
            if (charCount >= lTranslationTable.length) {
                throw runtime.newArgumentError("" + charCount + " is not a correct value for the number of bytes per line in a u directive.  Correct values range from 0 to " + lTranslationTable.length);
            }
            io2Append.append(lTranslationTable[charCount]);
            lPadding = 96;
        } else {
            lPadding = 61;
        }
        while (charCount >= 3) {
            lCurChar = charsToEncode[i2++];
            lNextChar = charsToEncode[i2++];
            byte lNextNextChar = charsToEncode[i2++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >>> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | lNextNextChar >>> 6 & 3)]);
            io2Append.append(lTranslationTable[0x3F & lNextNextChar]);
            charCount -= 3;
        }
        if (charCount == 2) {
            lCurChar = charsToEncode[i2++];
            lNextChar = charsToEncode[i2++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | lNextChar >> 4 & 0xF)]);
            io2Append.append(lTranslationTable[0x3F & (lNextChar << 2 & 0x3C | 0)]);
            io2Append.append(lPadding);
        } else if (charCount == 1) {
            lCurChar = charsToEncode[i2++];
            io2Append.append(lTranslationTable[0x3F & lCurChar >>> 2]);
            io2Append.append(lTranslationTable[0x3F & (lCurChar << 4 & 0x30 | 0)]);
            io2Append.append(lPadding);
            io2Append.append(lPadding);
        }
        if (tailLf) {
            io2Append.append(10);
        }
        return io2Append;
    }

    public static RubyArray unpack(Ruby runtime, ByteList encodedString, ByteList formatString) {
        Encoding encoding2 = encodedString.getEncoding();
        RubyArray result2 = runtime.newArray();
        ByteBuffer format = ByteBuffer.wrap(formatString.getUnsafeBytes(), formatString.begin(), formatString.length());
        ByteBuffer encode2 = ByteBuffer.wrap(encodedString.getUnsafeBytes(), encodedString.begin(), encodedString.length());
        int type2 = 0;
        int next2 = Pack.safeGet(format);
        block28: while (next2 != 0) {
            int index2;
            type2 = next2;
            next2 = Pack.safeGet(format);
            if (UNPACK_IGNORE_NULL_CODES.indexOf(type2) != -1 && next2 == 0) {
                next2 = Pack.safeGetIgnoreNull(format);
            }
            if (type2 == 35) {
                while (type2 != 10) {
                    if (next2 == 0) break block28;
                    type2 = next2;
                    next2 = Pack.safeGet(format);
                }
            }
            if (next2 == 95 || next2 == 33) {
                index2 = NATIVE_CODES.indexOf(type2);
                if (index2 == -1) {
                    throw runtime.newArgumentError("'" + next2 + "' allowed only after types " + NATIVE_CODES);
                }
                type2 = MAPPED_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
            }
            if (next2 == 62 || next2 == 60) {
                index2 = ENDIANESS_CODES.indexOf(type2 + (next2 = next2 == 62 ? 61 : 60));
                if (index2 == -1) {
                    throw runtime.newArgumentError("'" + (char)next2 + "' allowed only after types sSiIlLqQ");
                }
                type2 = ENDIANESS_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
                if (next2 == 95 || next2 == 33) {
                    next2 = Pack.safeGet(format);
                }
            }
            int occurrences = 0;
            if (next2 == 0) {
                occurrences = 1;
            } else if (next2 == 42) {
                occurrences = -1;
                next2 = Pack.safeGet(format);
            } else if (ASCII.isDigit(next2)) {
                occurrences = 0;
                do {
                    occurrences = occurrences * 10 + Character.digit((char)(next2 & 0xFF), 10);
                } while ((next2 = Pack.safeGet(format)) != 0 && ASCII.isDigit(next2));
            } else {
                occurrences = type2 == 64 ? 0 : 1;
            }
            Converter converter = converters[type2];
            if (converter != null) {
                Pack.decode(runtime, encode2, occurrences, result2, converter);
                type2 = next2;
                continue;
            }
            switch (type2) {
                case 64: {
                    try {
                        if (occurrences == -1) {
                            encode2.position(encodedString.begin() + encode2.remaining());
                            break;
                        }
                        encode2.position(encodedString.begin() + occurrences);
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw runtime.newArgumentError("@ outside of string");
                    }
                }
                case 37: {
                    throw runtime.newArgumentError("% is not supported");
                }
                case 65: {
                    byte c;
                    if (occurrences == -1 || occurrences > encode2.remaining()) {
                        occurrences = encode2.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode2.get(potential);
                    int t = occurrences - 1;
                    while (occurrences > 0 && ((c = potential[t]) == 0 || c == 32)) {
                        --occurrences;
                        --t;
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(potential, 0, occurrences, encoding2, false)));
                    break;
                }
                case 90: {
                    byte b2;
                    int t;
                    boolean isStar;
                    boolean bl = isStar = occurrences == -1;
                    if (occurrences == -1 || occurrences > encode2.remaining()) {
                        occurrences = encode2.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    for (t = 0; t < occurrences && (b2 = encode2.get()) != 0; ++t) {
                        potential[t] = b2;
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(potential, 0, t, encoding2, false)));
                    if (isStar) continue block28;
                    if (t < occurrences) {
                        ++t;
                    }
                    while (t < occurrences) {
                        encode2.get();
                        ++t;
                    }
                    continue block28;
                }
                case 97: {
                    if (occurrences == -1 || occurrences > encode2.remaining()) {
                        occurrences = encode2.remaining();
                    }
                    byte[] potential = new byte[occurrences];
                    encode2.get(potential);
                    result2.append(RubyString.newString(runtime, new ByteList(potential, encoding2, false)));
                    break;
                }
                case 98: {
                    int lCurByte;
                    if (occurrences == -1 || occurrences > encode2.remaining() * 8) {
                        occurrences = encode2.remaining() * 8;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits >>>= 1) : (int)encode2.get();
                        lElem[lCurByte] = (bits & 1) != 0 ? 49 : 48;
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(lElem, encoding2, false)));
                    break;
                }
                case 66: {
                    int lCurByte;
                    if (occurrences == -1 || occurrences > encode2.remaining() * 8) {
                        occurrences = encode2.remaining() * 8;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 7) != 0 ? (bits <<= 1) : (int)encode2.get();
                        lElem[lCurByte] = (bits & 0x80) != 0 ? 49 : 48;
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(lElem, encoding2, false)));
                    break;
                }
                case 104: {
                    int lCurByte;
                    if (occurrences == -1 || occurrences > encode2.remaining() * 2) {
                        occurrences = encode2.remaining() * 2;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits >>>= 4) : (int)encode2.get();
                        lElem[lCurByte] = sHexDigits[bits & 0xF];
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(lElem, encoding2, false)));
                    break;
                }
                case 72: {
                    int lCurByte;
                    if (occurrences == -1 || occurrences > encode2.remaining() * 2) {
                        occurrences = encode2.remaining() * 2;
                    }
                    int bits = 0;
                    byte[] lElem = new byte[occurrences];
                    for (lCurByte = 0; lCurByte < occurrences; ++lCurByte) {
                        bits = (lCurByte & 1) != 0 ? (bits <<= 4) : (int)encode2.get();
                        lElem[lCurByte] = sHexDigits[bits >>> 4 & 0xF];
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(lElem, encoding2, false)));
                    break;
                }
                case 117: {
                    int length2 = encode2.remaining() * 3 / 4;
                    byte[] lElem = new byte[length2];
                    int index3 = 0;
                    int s2 = 0;
                    int total2 = 0;
                    if (length2 > 0) {
                        s2 = encode2.get();
                    }
                    while (encode2.hasRemaining() && s2 > 32 && s2 < 97) {
                        byte[] hunk = new byte[3];
                        int len = s2 - 32 & 0x3F;
                        s2 = Pack.safeGet(encode2);
                        if ((total2 += len) > length2) {
                            len -= total2 - length2;
                            total2 = length2;
                        }
                        while (len > 0) {
                            int d;
                            int c;
                            int b3;
                            int a;
                            int mlen;
                            int n = mlen = len > 3 ? 3 : len;
                            if (encode2.hasRemaining() && s2 >= 32) {
                                a = s2 - 32 & 0x3F;
                                s2 = Pack.safeGet(encode2);
                            } else {
                                a = 0;
                            }
                            if (encode2.hasRemaining() && s2 >= 32) {
                                b3 = s2 - 32 & 0x3F;
                                s2 = Pack.safeGet(encode2);
                            } else {
                                b3 = 0;
                            }
                            if (encode2.hasRemaining() && s2 >= 32) {
                                c = s2 - 32 & 0x3F;
                                s2 = Pack.safeGet(encode2);
                            } else {
                                c = 0;
                            }
                            if (encode2.hasRemaining() && s2 >= 32) {
                                d = s2 - 32 & 0x3F;
                                s2 = Pack.safeGet(encode2);
                            } else {
                                d = 0;
                            }
                            hunk[0] = (byte)((a << 2 | b3 >> 4) & 0xFF);
                            hunk[1] = (byte)((b3 << 4 | c >> 2) & 0xFF);
                            hunk[2] = (byte)((c << 6 | d) & 0xFF);
                            for (int i2 = 0; i2 < mlen; ++i2) {
                                lElem[index3++] = hunk[i2];
                            }
                            len -= mlen;
                        }
                        if (s2 == 13) {
                            s2 = Pack.safeGet(encode2);
                        }
                        if (s2 == 10) {
                            s2 = Pack.safeGet(encode2);
                            continue;
                        }
                        if (!encode2.hasRemaining()) continue;
                        if (Pack.safeGet(encode2) == 10) {
                            Pack.safeGet(encode2);
                            continue;
                        }
                        if (!encode2.hasRemaining()) continue;
                        encode2.position(encode2.position() - 1);
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(lElem, 0, index3, encoding2, false)));
                    break;
                }
                case 109: {
                    int d;
                    int length3 = encode2.remaining() * 3 / 4;
                    byte[] lElem = new byte[length3];
                    int a = -1;
                    int b4 = -1;
                    int c = 0;
                    int index4 = 0;
                    int s3 = -1;
                    if (occurrences == 0) {
                        if (encode2.remaining() % 4 != 0) {
                            throw runtime.newArgumentError("invalid base64");
                        }
                        while (encode2.hasRemaining() && s3 != 61) {
                            c = -1;
                            b4 = -1;
                            a = -1;
                            d = -2;
                            s3 = Pack.safeGet(encode2);
                            a = b64_xtable[s3];
                            if (a == -1) {
                                throw runtime.newArgumentError("invalid base64");
                            }
                            s3 = Pack.safeGet(encode2);
                            b4 = b64_xtable[s3];
                            if (b4 == -1) {
                                throw runtime.newArgumentError("invalid base64");
                            }
                            s3 = Pack.safeGet(encode2);
                            c = b64_xtable[s3];
                            if (s3 == 61) {
                                if (Pack.safeGet(encode2) == 61) break;
                                throw runtime.newArgumentError("invalid base64");
                            }
                            if (c == -1) {
                                throw runtime.newArgumentError("invalid base64");
                            }
                            s3 = Pack.safeGet(encode2);
                            d = b64_xtable[s3];
                            if (s3 == 61) break;
                            if (d == -1) {
                                throw runtime.newArgumentError("invalid base64");
                            }
                            lElem[index4++] = (byte)((a << 2 | b4 >> 4) & 0xFF);
                            lElem[index4++] = (byte)((b4 << 4 | c >> 2) & 0xFF);
                            lElem[index4++] = (byte)((c << 6 | d) & 0xFF);
                        }
                        if (encode2.hasRemaining()) {
                            throw runtime.newArgumentError("invalid base64");
                        }
                        if (a != -1 && b4 != -1) {
                            if (c == -1 && s3 == 61) {
                                if ((b4 & 0xF) > 0) {
                                    throw runtime.newArgumentError("invalid base64");
                                }
                                lElem[index4++] = (byte)((a << 2 | b4 >> 4) & 0xFF);
                            } else if (c != -1 && s3 == 61) {
                                if ((c & 3) > 0) {
                                    throw runtime.newArgumentError("invalid base64");
                                }
                                lElem[index4++] = (byte)((a << 2 | b4 >> 4) & 0xFF);
                                lElem[index4++] = (byte)((b4 << 4 | c >> 2) & 0xFF);
                            }
                        }
                    } else {
                        while (encode2.hasRemaining()) {
                            d = -1;
                            c = -1;
                            b4 = -1;
                            a = -1;
                            s3 = Pack.safeGet(encode2);
                            while ((a = b64_xtable[s3]) == -1 && encode2.hasRemaining()) {
                                s3 = Pack.safeGet(encode2);
                            }
                            if (a == -1) break;
                            s3 = Pack.safeGet(encode2);
                            while ((b4 = b64_xtable[s3]) == -1 && encode2.hasRemaining()) {
                                s3 = Pack.safeGet(encode2);
                            }
                            if (b4 == -1) break;
                            s3 = Pack.safeGet(encode2);
                            while ((c = b64_xtable[s3]) == -1 && encode2.hasRemaining() && s3 != 61) {
                                s3 = Pack.safeGet(encode2);
                            }
                            if (s3 == 61 || c == -1) {
                                if (s3 != 61) break;
                                encode2.position(encode2.position() - 1);
                                break;
                            }
                            s3 = Pack.safeGet(encode2);
                            while ((d = b64_xtable[s3]) == -1 && encode2.hasRemaining() && s3 != 61) {
                                s3 = Pack.safeGet(encode2);
                            }
                            if (s3 == 61 || d == -1) {
                                if (s3 != 61) break;
                                encode2.position(encode2.position() - 1);
                                break;
                            }
                            lElem[index4++] = (byte)((a << 2 | b4 >> 4) & 0xFF);
                            lElem[index4++] = (byte)((b4 << 4 | c >> 2) & 0xFF);
                            lElem[index4++] = (byte)((c << 6 | d) & 0xFF);
                        }
                        if (a != -1 && b4 != -1) {
                            if (c == -1 && s3 == 61) {
                                lElem[index4++] = (byte)((a << 2 | b4 >> 4) & 0xFF);
                            } else if (c != -1 && s3 == 61) {
                                lElem[index4++] = (byte)((a << 2 | b4 >> 4) & 0xFF);
                                lElem[index4++] = (byte)((b4 << 4 | c >> 2) & 0xFF);
                            }
                        }
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(lElem, 0, index4, (Encoding)ASCIIEncoding.INSTANCE, false)));
                    break;
                }
                case 77: {
                    byte[] lElem = new byte[Math.max(encode2.remaining(), 0)];
                    int index5 = 0;
                    while (encode2.hasRemaining()) {
                        int c = Pack.safeGet(encode2);
                        if (c != 61) {
                            lElem[index5++] = (byte)c;
                            continue;
                        }
                        if (!encode2.hasRemaining()) break;
                        encode2.mark();
                        int c1 = Pack.safeGet(encode2);
                        if (c1 == 10 || c1 == 13 && (c1 = Pack.safeGet(encode2)) == 10) continue;
                        int d1 = Character.digit(c1, 16);
                        if (d1 == -1) {
                            encode2.reset();
                            break;
                        }
                        encode2.mark();
                        if (!encode2.hasRemaining()) break;
                        int c2 = Pack.safeGet(encode2);
                        int d2 = Character.digit(c2, 16);
                        if (d2 == -1) {
                            encode2.reset();
                            break;
                        }
                        byte value2 = (byte)(d1 << 4 | d2);
                        lElem[index5++] = value2;
                    }
                    result2.append(RubyString.newString(runtime, new ByteList(lElem, 0, index5, (Encoding)ASCIIEncoding.INSTANCE, false)));
                    break;
                }
                case 85: {
                    if (occurrences == -1 || occurrences > encode2.remaining()) {
                        occurrences = encode2.remaining();
                    }
                    while (occurrences-- > 0 && encode2.remaining() > 0) {
                        try {
                            result2.append(runtime.newFixnum(Pack.utf8Decode(encode2)));
                        }
                        catch (IllegalArgumentException e) {
                            throw runtime.newArgumentError(e.getMessage());
                        }
                    }
                    break;
                }
                case 88: {
                    if (occurrences == -1) {
                        occurrences = encode2.remaining();
                    }
                    try {
                        encode2.position(encode2.position() - occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': X outside of string");
                    }
                }
                case 120: {
                    if (occurrences == -1) {
                        occurrences = encode2.remaining();
                    }
                    try {
                        encode2.position(encode2.position() + occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': x outside of string");
                    }
                }
                case 119: {
                    if (occurrences == -1 || occurrences > encode2.remaining()) {
                        occurrences = encode2.remaining();
                    }
                    long ul = 0L;
                    long ulmask = -33554432L;
                    RubyBignum big128 = RubyBignum.newBignum(runtime, 128L);
                    int pos2 = encode2.position();
                    block49: while (occurrences > 0 && pos2 < encode2.limit()) {
                        ul <<= 7;
                        ul |= (long)(encode2.get(pos2) & 0x7F);
                        if ((encode2.get(pos2++) & 0x80) == 0) {
                            result2.append(RubyFixnum.newFixnum(runtime, ul));
                            --occurrences;
                            ul = 0L;
                            continue;
                        }
                        if ((ul & ulmask) != 0L) continue;
                        RubyBignum big = RubyBignum.newBignum(runtime, ul);
                        while (occurrences > 0 && pos2 < encode2.limit()) {
                            IRubyObject mulResult = big.op_mul(runtime.getCurrentContext(), big128);
                            IRubyObject v = mulResult.callMethod(runtime.getCurrentContext(), "+", RubyBignum.newBignum(runtime, encode2.get(pos2) & 0x7F));
                            if (v instanceof RubyFixnum) {
                                big = RubyBignum.newBignum(runtime, RubyNumeric.fix2long(v));
                            } else if (v instanceof RubyBignum) {
                                big = (RubyBignum)v;
                            }
                            if ((encode2.get(pos2++) & 0x80) != 0) continue;
                            result2.add(RubyBignum.bignorm(runtime, big.getValue()));
                            --occurrences;
                            ul = 0L;
                            continue block49;
                        }
                    }
                    try {
                        encode2.position(pos2);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `unpack': poorly encoded input");
                    }
                }
            }
        }
        return result2;
    }

    public static int utf8Decode(Ruby runtime, byte[] to, int p2, int code) {
        if (code <= 127) {
            to[p2] = (byte)code;
            return 1;
        }
        if (code <= 2047) {
            to[p2 + 0] = (byte)(code >>> 6 & 0xFF | 0xC0);
            to[p2 + 1] = (byte)(code & 0x3F | 0x80);
            return 2;
        }
        if (code <= 65535) {
            to[p2 + 0] = (byte)(code >>> 12 & 0xFF | 0xE0);
            to[p2 + 1] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code & 0x3F | 0x80);
            return 3;
        }
        if (code <= 0x1FFFFF) {
            to[p2 + 0] = (byte)(code >>> 18 & 0xFF | 0xF0);
            to[p2 + 1] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code & 0x3F | 0x80);
            return 4;
        }
        if (code <= 0x3FFFFFF) {
            to[p2 + 0] = (byte)(code >>> 24 & 0xFF | 0xF8);
            to[p2 + 1] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 4] = (byte)(code & 0x3F | 0x80);
            return 5;
        }
        if (code <= Integer.MAX_VALUE) {
            to[p2 + 0] = (byte)(code >>> 30 & 0xFF | 0xFC);
            to[p2 + 1] = (byte)(code >>> 24 & 0x3F | 0x80);
            to[p2 + 2] = (byte)(code >>> 18 & 0x3F | 0x80);
            to[p2 + 3] = (byte)(code >>> 12 & 0x3F | 0x80);
            to[p2 + 4] = (byte)(code >>> 6 & 0x3F | 0x80);
            to[p2 + 5] = (byte)(code & 0x3F | 0x80);
            return 6;
        }
        throw runtime.newRangeError("pack(U): value out of range");
    }

    private static int utf8Decode(ByteBuffer buffer) {
        int n;
        int c;
        int uv = c = buffer.get() & 0xFF;
        if ((c & 0x80) == 0) {
            return c;
        }
        if ((c & 0x40) == 0) {
            throw new IllegalArgumentException("malformed UTF-8 character");
        }
        if ((uv & 0x20) == 0) {
            n = 2;
            uv &= 0x1F;
        } else if ((uv & 0x10) == 0) {
            n = 3;
            uv &= 0xF;
        } else if ((uv & 8) == 0) {
            n = 4;
            uv &= 7;
        } else if ((uv & 4) == 0) {
            n = 5;
            uv &= 3;
        } else if ((uv & 2) == 0) {
            n = 6;
            uv &= 1;
        } else {
            throw new IllegalArgumentException("malformed UTF-8 character");
        }
        if (n > buffer.remaining() + 1) {
            throw new IllegalArgumentException("malformed UTF-8 character (expected " + n + " bytes, " + "given " + (buffer.remaining() + 1) + " bytes)");
        }
        int limit2 = n - 1;
        if (--n != 0) {
            while (n-- != 0) {
                c = buffer.get() & 0xFF;
                if ((c & 0xC0) != 128) {
                    throw new IllegalArgumentException("malformed UTF-8 character");
                }
                uv = uv << 6 | (c &= 0x3F);
            }
        }
        if ((long)uv < utf8_limits[limit2]) {
            throw new IllegalArgumentException("redundant UTF-8 sequence");
        }
        return uv;
    }

    private static int safeGet(ByteBuffer encode2) {
        while (encode2.hasRemaining()) {
            int got = encode2.get() & 0xFF;
            if (got == 0) continue;
            return got;
        }
        return 0;
    }

    private static int safeGetIgnoreNull(ByteBuffer encode2) {
        int next2 = 0;
        while (encode2.hasRemaining() && next2 == 0) {
            next2 = Pack.safeGet(encode2);
        }
        return next2;
    }

    public static void decode(Ruby runtime, ByteBuffer encode2, int occurrences, RubyArray result2, Converter converter) {
        int lPadLength = 0;
        if (occurrences == -1) {
            occurrences = encode2.remaining() / converter.size;
        } else if (occurrences > encode2.remaining() / converter.size) {
            lPadLength = occurrences - encode2.remaining() / converter.size;
            occurrences = encode2.remaining() / converter.size;
        }
        while (occurrences-- > 0) {
            result2.append(converter.decode(runtime, encode2));
        }
        while (lPadLength-- > 0) {
            result2.append(runtime.getNil());
        }
    }

    public static int encode(Ruby runtime, int occurrences, ByteList result2, RubyArray list2, int index2, ConverterExecutor converter) {
        int listSize = list2.size();
        while (occurrences-- > 0) {
            if (listSize-- <= 0 || index2 >= list2.size()) {
                throw runtime.newArgumentError(sTooFew);
            }
            IRubyObject from = list2.eltInternal(index2++);
            converter.encode(runtime, from, result2);
        }
        return index2;
    }

    private static ConverterExecutor executor() {
        return new ConverterExecutor(){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer format) {
                return this.converter.decode(runtime, format);
            }

            @Override
            public void encode(Ruby runtime, IRubyObject from, ByteList result2) {
                if (from == runtime.getNil() && this.converter.getType() != null) {
                    throw runtime.newTypeError(from, this.converter.getType());
                }
                this.converter.encode(runtime, from, result2);
            }
        };
    }

    private static final ByteList shrink(ByteList i2Shrink, int iLength) {
        iLength = i2Shrink.length() - iLength;
        if (iLength < 0) {
            throw new IllegalArgumentException();
        }
        i2Shrink.length(iLength);
        return i2Shrink;
    }

    private static final ByteList grow(ByteList i2Grow, byte[] iPads, int iLength) {
        int lPadLength = iPads.length;
        while (iLength >= lPadLength) {
            i2Grow.append(iPads);
            iLength -= lPadLength;
        }
        i2Grow.append(iPads, 0, iLength);
        return i2Grow;
    }

    public static RubyString pack(Ruby runtime, RubyArray list2, ByteList formatString) {
        return Pack.packCommon(runtime, list2, formatString, false, Pack.executor());
    }

    public static RubyString pack(ThreadContext context, Ruby runtime, RubyArray list2, RubyString formatString) {
        RubyString pack2 = Pack.packCommon(runtime, list2, formatString.getByteList(), formatString.isTaint(), Pack.executor());
        return (RubyString)pack2.infectBy((IRubyObject)formatString);
    }

    private static RubyString packCommon(Ruby runtime, RubyArray list2, ByteList formatString, boolean tainted, ConverterExecutor executor) {
        ByteBuffer format = ByteBuffer.wrap(formatString.getUnsafeBytes(), formatString.begin(), formatString.length());
        ByteList result2 = new ByteList();
        boolean taintOutput = tainted;
        int listSize = list2.size();
        int type2 = 0;
        int next2 = Pack.safeGet(format);
        int idx = 0;
        int enc_info = 1;
        block31: while (next2 != 0) {
            Converter converter;
            int index2;
            type2 = next2;
            next2 = Pack.safeGet(format);
            if (PACK_IGNORE_NULL_CODES.indexOf(type2) != -1 && next2 == 0) {
                next2 = Pack.safeGetIgnoreNull(format);
            }
            while (ASCII.isSpace(type2)) {
                if (next2 == 0) break block31;
                type2 = next2;
                next2 = Pack.safeGet(format);
            }
            if (type2 == 35) {
                while (type2 != 10) {
                    if (next2 == 0) break block31;
                    type2 = next2;
                    next2 = Pack.safeGet(format);
                }
            }
            if (next2 == 33 || next2 == 95) {
                index2 = NATIVE_CODES.indexOf(type2);
                if (index2 == -1) {
                    throw runtime.newArgumentError("'" + next2 + "' allowed only after types " + NATIVE_CODES);
                }
                int typeBeforeMap = type2;
                type2 = MAPPED_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
                if (PACK_IGNORE_NULL_CODES_WITH_MODIFIERS.indexOf(typeBeforeMap) != -1 && next2 == 0) {
                    next2 = Pack.safeGetIgnoreNull(format);
                }
            }
            if (next2 == 62 || next2 == 60) {
                index2 = ENDIANESS_CODES.indexOf(type2 + (next2 = next2 == 62 ? 61 : 60));
                if (index2 == -1) {
                    throw runtime.newArgumentError("'" + (char)next2 + "' allowed only after types sSiIlLqQ");
                }
                type2 = ENDIANESS_CODES.charAt(index2);
                next2 = Pack.safeGet(format);
            }
            int occurrences = 1;
            boolean isStar = false;
            boolean ignoreStar = false;
            if (next2 != 0) {
                if (next2 == 42) {
                    if ("@XxumM".indexOf(type2) != -1) {
                        occurrences = 0;
                        ignoreStar = true;
                    } else {
                        occurrences = list2.size() - idx;
                        isStar = true;
                    }
                    next2 = Pack.safeGet(format);
                } else if (ASCII.isDigit(next2)) {
                    occurrences = 0;
                    do {
                        occurrences = occurrences * 10 + Character.digit((char)(next2 & 0xFF), 10);
                    } while ((next2 = Pack.safeGet(format)) != 0 && ASCII.isDigit(next2));
                }
            }
            switch (type2) {
                case 85: {
                    if (enc_info != 1) break;
                    enc_info = 2;
                    break;
                }
                case 77: 
                case 109: 
                case 117: {
                    break;
                }
                default: {
                    enc_info = 0;
                }
            }
            if ((converter = converters[type2]) != null) {
                executor.setConverter(converter);
                idx = Pack.encode(runtime, occurrences, result2, list2, idx, executor);
                continue;
            }
            block5 : switch (type2) {
                case 37: {
                    throw runtime.newArgumentError("% is not supported");
                }
                case 65: 
                case 66: 
                case 72: 
                case 90: 
                case 97: 
                case 98: 
                case 104: {
                    ByteList lCurElemString;
                    IRubyObject from;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    if ((from = list2.eltInternal(idx++)).isTaint()) {
                        taintOutput = true;
                    }
                    ByteList byteList = lCurElemString = from == runtime.getNil() ? ByteList.EMPTY_BYTELIST : from.convertToString().getByteList();
                    if (isStar) {
                        occurrences = lCurElemString.length();
                        if (type2 == 90) {
                            ++occurrences;
                        }
                    }
                    switch (type2) {
                        case 65: 
                        case 90: 
                        case 97: {
                            if (lCurElemString.length() >= occurrences) {
                                result2.append(lCurElemString.getUnsafeBytes(), lCurElemString.getBegin(), occurrences);
                                break block5;
                            }
                            result2.append(lCurElemString);
                            occurrences -= lCurElemString.length();
                            switch (type2) {
                                case 90: 
                                case 97: {
                                    Pack.grow(result2, sNil10, occurrences);
                                    break block5;
                                }
                            }
                            Pack.grow(result2, sSp10, occurrences);
                            break block5;
                        }
                        case 98: {
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = (occurrences - lCurElemString.length()) / 2 + (occurrences + lCurElemString.length()) % 2;
                                occurrences = lCurElemString.length();
                            }
                            int i2 = 0;
                            while (i2 < occurrences) {
                                if ((lCurElemString.charAt(i2++) & '\u0001') != 0) {
                                    currentByte |= 0x80;
                                }
                                if ((i2 & 7) == 0) {
                                    result2.append((byte)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte >>= 1;
                            }
                            if ((occurrences & 7) != 0) {
                                result2.append((byte)((currentByte >>= 7 - (occurrences & 7)) & 0xFF));
                            }
                            result2.length(result2.length() + padLength);
                            break block5;
                        }
                        case 66: {
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = (occurrences - lCurElemString.length()) / 2 + (occurrences + lCurElemString.length()) % 2;
                                occurrences = lCurElemString.length();
                            }
                            int i2 = 0;
                            while (i2 < occurrences) {
                                currentByte |= lCurElemString.charAt(i2++) & '\u0001';
                                if ((i2 & 7) == 0) {
                                    result2.append((byte)(currentByte & 0xFF));
                                    currentByte = 0;
                                    continue;
                                }
                                currentByte <<= 1;
                            }
                            if ((occurrences & 7) != 0) {
                                result2.append((byte)((currentByte <<= 7 - (occurrences & 7)) & 0xFF));
                            }
                            result2.length(result2.length() + padLength);
                            break block5;
                        }
                        case 104: {
                            byte currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length() + 1;
                                occurrences = lCurElemString.length();
                            }
                            int i2 = 0;
                            while (i2 < occurrences) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = (byte)lCurElemString.charAt(i2++)) ? (currentByte |= ((currentChar & 0xF) + 9 & 0xF) << 4) : (currentByte |= (currentChar & 0xF) << 4);
                                if ((i2 & 1) != 0) {
                                    currentByte >>= 4;
                                    continue;
                                }
                                result2.append((byte)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((occurrences & 1) != 0) {
                                result2.append((byte)(currentByte & 0xFF));
                                if (padLength > 0) {
                                    --padLength;
                                }
                            }
                            result2.length(result2.length() + padLength / 2);
                            break block5;
                        }
                        case 72: {
                            byte currentChar;
                            int currentByte = 0;
                            int padLength = 0;
                            if (occurrences > lCurElemString.length()) {
                                padLength = occurrences - lCurElemString.length() + 1;
                                occurrences = lCurElemString.length();
                            }
                            int i2 = 0;
                            while (i2 < occurrences) {
                                currentByte = Character.isJavaIdentifierStart(currentChar = (byte)lCurElemString.charAt(i2++)) ? (currentByte |= (currentChar & 0xF) + 9 & 0xF) : (currentByte |= currentChar & 0xF);
                                if ((i2 & 1) != 0) {
                                    currentByte <<= 4;
                                    continue;
                                }
                                result2.append((byte)(currentByte & 0xFF));
                                currentByte = 0;
                            }
                            if ((occurrences & 1) != 0) {
                                result2.append((byte)(currentByte & 0xFF));
                                if (padLength > 0) {
                                    --padLength;
                                }
                            }
                            result2.length(result2.length() + padLength / 2);
                        }
                    }
                    break;
                }
                case 120: {
                    Pack.grow(result2, sNil10, occurrences);
                    break;
                }
                case 88: {
                    try {
                        Pack.shrink(result2, occurrences);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        throw runtime.newArgumentError("in `pack': X outside of string");
                    }
                }
                case 64: {
                    if ((occurrences -= result2.length()) > 0) {
                        Pack.grow(result2, sNil10, occurrences);
                    }
                    if ((occurrences = -occurrences) <= 0) break;
                    Pack.shrink(result2, occurrences);
                    break;
                }
                case 109: 
                case 117: {
                    IRubyObject from;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    if ((from = list2.eltInternal(idx++)) == runtime.getNil()) {
                        throw runtime.newTypeError(from, "Integer");
                    }
                    ByteList lCurElemString = from.convertToString().getByteList();
                    Pack.encodeUM(runtime, lCurElemString, occurrences, ignoreStar, (char)type2, result2);
                    break;
                }
                case 77: {
                    ByteList lCurElemString;
                    IRubyObject from;
                    if (listSize-- <= 0) {
                        throw runtime.newArgumentError(sTooFew);
                    }
                    ByteList byteList = lCurElemString = (from = list2.eltInternal(idx++)) == runtime.getNil() ? ByteList.EMPTY_BYTELIST : from.asString().getByteList();
                    if (occurrences <= 1) {
                        occurrences = 72;
                    }
                    PackUtils.qpencode(result2, lCurElemString, occurrences);
                    break;
                }
                case 85: {
                    IRubyObject from;
                    while (occurrences-- > 0) {
                        int code;
                        if (listSize-- <= 0) {
                            throw runtime.newArgumentError(sTooFew);
                        }
                        int n = code = (from = list2.eltInternal(idx++)) == runtime.getNil() ? 0 : RubyNumeric.num2int(from);
                        if (code < 0) {
                            throw runtime.newRangeError("pack(U): value out of range");
                        }
                        result2.ensure(result2.getRealSize() + 6);
                        result2.setRealSize(result2.getRealSize() + Pack.utf8Decode(runtime, result2.getUnsafeBytes(), result2.getBegin() + result2.getRealSize(), code));
                    }
                    break;
                }
                case 119: {
                    while (occurrences-- > 0) {
                        long l;
                        IRubyObject from;
                        if (listSize-- <= 0) {
                            throw runtime.newArgumentError(sTooFew);
                        }
                        ByteList buf = new ByteList();
                        if ((from = list2.eltInternal(idx++)).isNil()) {
                            throw runtime.newTypeError("pack('w') does not take nil");
                        }
                        if (from instanceof RubyBignum) {
                            RubyBignum big128 = RubyBignum.newBignum(runtime, 128L);
                            while (from instanceof RubyBignum) {
                                RubyBignum bignum = (RubyBignum)from;
                                RubyArray ary = (RubyArray)bignum.divmod(runtime.getCurrentContext(), big128);
                                buf.append((byte)(RubyNumeric.fix2int(ary.at(RubyFixnum.one(runtime))) | 0x80) & 0xFF);
                                from = ary.at(RubyFixnum.zero(runtime));
                            }
                        }
                        if ((l = RubyNumeric.num2long(from)) >= 0L) {
                            while (l != 0L) {
                                buf.append((byte)((l & 0x7FL | 0x80L) & 0xFFL));
                                l >>= 7;
                            }
                            int left2 = 0;
                            int right = buf.getRealSize() - 1;
                            if (right >= 0) {
                                byte[] byArray = buf.getUnsafeBytes();
                                byArray[0] = (byte)(byArray[0] & 0x7F);
                            } else {
                                buf.append(0);
                            }
                            while (left2 < right) {
                                byte tmp = buf.getUnsafeBytes()[left2];
                                buf.getUnsafeBytes()[left2] = buf.getUnsafeBytes()[right];
                                buf.getUnsafeBytes()[right] = tmp;
                                ++left2;
                                --right;
                            }
                            result2.append(buf);
                            continue;
                        }
                        throw runtime.newArgumentError("can't compress negative numbers");
                    }
                    break;
                }
            }
        }
        RubyString output = runtime.newString(result2);
        if (taintOutput) {
            output.taint(runtime.getCurrentContext());
        }
        switch (enc_info) {
            case 1: {
                output.setEncodingAndCodeRange((Encoding)USASCII, 4096);
                break;
            }
            case 2: {
                output.force_encoding(runtime.getCurrentContext(), runtime.getEncodingService().convertEncodingToRubyEncoding((Encoding)UTF8));
                break;
            }
        }
        return output;
    }

    private static int decodeIntLittleEndian(ByteBuffer encode2) {
        encode2.order(ByteOrder.LITTLE_ENDIAN);
        int value2 = encode2.getInt();
        encode2.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static int decodeIntBigEndian(ByteBuffer encode2) {
        return encode2.getInt();
    }

    private static long decodeIntUnsignedBigEndian(ByteBuffer encode2) {
        return (long)encode2.getInt() & 0xFFFFFFFFL;
    }

    private static long decodeIntUnsignedLittleEndian(ByteBuffer encode2) {
        encode2.order(ByteOrder.LITTLE_ENDIAN);
        long value2 = (long)encode2.getInt() & 0xFFFFFFFFL;
        encode2.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static void encodeIntLittleEndian(ByteList result2, int s2) {
        result2.append((byte)(s2 & 0xFF)).append((byte)(s2 >> 8 & 0xFF));
        result2.append((byte)(s2 >> 16 & 0xFF)).append((byte)(s2 >> 24 & 0xFF));
    }

    private static void encodeIntBigEndian(ByteList result2, int s2) {
        result2.append((byte)(s2 >> 24 & 0xFF)).append((byte)(s2 >> 16 & 0xFF));
        result2.append((byte)(s2 >> 8 & 0xFF)).append((byte)(s2 & 0xFF));
    }

    private static long decodeLongBigEndian(ByteBuffer encode2) {
        int c1 = Pack.decodeIntBigEndian(encode2);
        int c2 = Pack.decodeIntBigEndian(encode2);
        return ((long)c1 << 32) + ((long)c2 & 0xFFFFFFFFL);
    }

    private static long decodeLongLittleEndian(ByteBuffer encode2) {
        int c1 = Pack.decodeIntLittleEndian(encode2);
        int c2 = Pack.decodeIntLittleEndian(encode2);
        return ((long)c2 << 32) + ((long)c1 & 0xFFFFFFFFL);
    }

    private static void encodeLongLittleEndian(ByteList result2, long l) {
        Pack.encodeIntLittleEndian(result2, (int)(l & 0xFFFFFFFFFFFFFFFFL));
        Pack.encodeIntLittleEndian(result2, (int)(l >>> 32));
    }

    private static void encodeLongBigEndian(ByteList result2, long l) {
        Pack.encodeIntBigEndian(result2, (int)(l >>> 32));
        Pack.encodeIntBigEndian(result2, (int)(l & 0xFFFFFFFFFFFFFFFFL));
    }

    private static double decodeDoubleLittleEndian(ByteBuffer encode2) {
        return Double.longBitsToDouble(Pack.decodeLongLittleEndian(encode2));
    }

    private static double decodeDoubleBigEndian(ByteBuffer encode2) {
        return Double.longBitsToDouble(Pack.decodeLongBigEndian(encode2));
    }

    private static void encodeDoubleLittleEndian(ByteList result2, double d) {
        Pack.encodeLongLittleEndian(result2, Double.doubleToRawLongBits(d));
    }

    private static void encodeDoubleBigEndian(ByteList result2, double d) {
        Pack.encodeLongBigEndian(result2, Double.doubleToRawLongBits(d));
    }

    private static float decodeFloatBigEndian(ByteBuffer encode2) {
        return Float.intBitsToFloat(Pack.decodeIntBigEndian(encode2));
    }

    private static float decodeFloatLittleEndian(ByteBuffer encode2) {
        return Float.intBitsToFloat(Pack.decodeIntLittleEndian(encode2));
    }

    private static void encodeFloatLittleEndian(ByteList result2, float f) {
        Pack.encodeIntLittleEndian(result2, Float.floatToRawIntBits(f));
    }

    private static void encodeFloatBigEndian(ByteList result2, float f) {
        Pack.encodeIntBigEndian(result2, Float.floatToRawIntBits(f));
    }

    private static int decodeShortUnsignedLittleEndian(ByteBuffer encode2) {
        encode2.order(ByteOrder.LITTLE_ENDIAN);
        int value2 = encode2.getShort() & 0xFFFF;
        encode2.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static int decodeShortUnsignedBigEndian(ByteBuffer encode2) {
        int value2 = encode2.getShort() & 0xFFFF;
        return value2;
    }

    private static int decodeShortLittleEndian(ByteBuffer encode2) {
        encode2.order(ByteOrder.LITTLE_ENDIAN);
        short value2 = encode2.getShort();
        encode2.order(ByteOrder.BIG_ENDIAN);
        return value2;
    }

    private static short decodeShortBigEndian(ByteBuffer encode2) {
        return encode2.getShort();
    }

    private static void encodeShortLittleEndian(ByteList result2, int s2) {
        result2.append((byte)(s2 & 0xFF)).append((byte)((s2 & 0xFF00) >> 8));
    }

    private static void encodeShortBigEndian(ByteList result2, int s2) {
        result2.append((byte)((s2 & 0xFF00) >> 8)).append((byte)(s2 & 0xFF));
    }

    static {
        Converter tmp;
        int i2;
        sSp10 = "          ".getBytes();
        sNil10 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".getBytes();
        ASCII = ASCIIEncoding.INSTANCE;
        USASCII = USASCIIEncoding.INSTANCE;
        UTF8 = UTF8Encoding.INSTANCE;
        ENDIANESS_CODES = new String(new char[]{'\u00b0', '\u0090', '\u00a6', '\u0086', '\u00a9', '\u0089', '\u00ae', '\u008e', '\u00af', '\u008f', '\u00a5', '\u0085', '\u00a8', '\u0088', '\u00ad', '\u008d'});
        b64_xtable = new int[256];
        converters = new Converter[256];
        uu_table = ByteList.plain((CharSequence)"`!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_");
        b64_table = ByteList.plain((CharSequence)"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
        sHexDigits = ByteList.plain((CharSequence)"0123456789abcdef0123456789ABCDEFx");
        for (i2 = 0; i2 < 256; ++i2) {
            Pack.b64_xtable[i2] = -1;
        }
        for (i2 = 0; i2 < 64; ++i2) {
            Pack.b64_xtable[Pack.b64_table[i2]] = i2;
        }
        Pack.converters[101] = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeFloatLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeFloatLittleEndian(result2, Pack.obj2flt(runtime, o));
            }
        };
        Pack.converters[103] = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeFloatBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeFloatBigEndian(result2, Pack.obj2flt(runtime, o));
            }
        };
        Pack.converters[70] = tmp = new Converter(4){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Platform.BYTE_ORDER == 4321 ? (double)Pack.decodeFloatBigEndian(enc) : (double)Pack.decodeFloatLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                if (Platform.BYTE_ORDER == 4321) {
                    Pack.encodeFloatBigEndian(result2, Pack.obj2flt(runtime, o));
                } else {
                    Pack.encodeFloatLittleEndian(result2, Pack.obj2flt(runtime, o));
                }
            }
        };
        Pack.converters[102] = tmp;
        Pack.converters[69] = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeDoubleLittleEndian(result2, Pack.obj2dbl(runtime, o));
            }
        };
        Pack.converters[71] = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeDoubleBigEndian(result2, Pack.obj2dbl(runtime, o));
            }
        };
        Pack.converters[68] = tmp = new Converter(8){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                if (Platform.BYTE_ORDER == 4321) {
                    return RubyFloat.newFloat(runtime, Pack.decodeDoubleBigEndian(enc));
                }
                return RubyFloat.newFloat(runtime, Pack.decodeDoubleLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeDoubleLittleEndian(result2, Pack.obj2dbl(runtime, o));
            }
        };
        Pack.converters[100] = tmp;
        Pack.converters[118] = tmp = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeShortLittleEndian(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[143] = tmp;
        Pack.converters[110] = tmp = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortUnsignedBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeShortBigEndian(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[144] = tmp;
        Pack.converters[115] = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Platform.BYTE_ORDER == 4321 ? Pack.decodeShortBigEndian(enc) : Pack.decodeShortLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                this.encodeShortByByteOrder(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[83] = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Platform.BYTE_ORDER == 4321 ? Pack.decodeShortUnsignedBigEndian(enc) : Pack.decodeShortUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                this.encodeShortByByteOrder(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[175] = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeShortLittleEndian(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[176] = new QuadConverter(2, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeShortBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeShortBigEndian(result2, this.overflowQuad(Pack.num2quad(o)));
            }
        };
        Pack.converters[99] = new Converter(1, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                int c = enc.get();
                return runtime.newFixnum(c > 127 ? c - 256 : c);
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                byte c = (byte)(Pack.num2quad(o) & 0xFFL);
                result2.append(c);
            }
        };
        Pack.converters[67] = new Converter(1, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(enc.get() & 0xFF);
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                byte c = o == runtime.getNil() ? (byte)0 : (byte)(Pack.num2quad(o) & 0xFFL);
                result2.append(c);
            }
        };
        Pack.converters[86] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeIntLittleEndian(result2, (int)RubyNumeric.num2long(o));
            }
        };
        Pack.converters[136] = tmp;
        Pack.converters[133] = tmp;
        Pack.converters[78] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntUnsignedBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeIntBigEndian(result2, (int)RubyNumeric.num2long(o));
            }
        };
        Pack.converters[137] = tmp;
        Pack.converters[134] = tmp;
        Pack.converters[73] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                if (Platform.BYTE_ORDER == 4321) {
                    return runtime.newFixnum(Pack.decodeIntUnsignedBigEndian(enc));
                }
                return runtime.newFixnum(Pack.decodeIntUnsignedLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                int s2 = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.packInt_i(result2, s2);
            }
        };
        Pack.converters[76] = tmp;
        Pack.converters[105] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                int value2 = Pack.unpackInt_i(enc);
                return runtime.newFixnum(value2);
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                int s2 = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.packInt_i(result2, s2);
            }
        };
        Pack.converters[108] = tmp;
        Pack.converters[165] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                int s2 = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntLittleEndian(result2, s2);
            }
        };
        Pack.converters[168] = tmp;
        Pack.converters[166] = tmp = new Converter(4, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeIntBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                int s2 = o == runtime.getNil() ? 0 : (int)RubyNumeric.num2long(o);
                Pack.encodeIntBigEndian(result2, s2);
            }
        };
        Pack.converters[169] = tmp;
        Pack.converters[81] = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                long l = Platform.BYTE_ORDER == 4321 ? Pack.decodeLongBigEndian(enc) : Pack.decodeLongLittleEndian(enc);
                return RubyBignum.bignorm(runtime, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                this.encodeLongByByteOrder(result2, Pack.num2quad(o));
            }
        };
        Pack.converters[141] = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                long l = Pack.decodeLongLittleEndian(enc);
                return RubyBignum.bignorm(runtime, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeLongLittleEndian(result2, Pack.num2quad(o));
            }
        };
        Pack.converters[142] = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                long l = Pack.decodeLongBigEndian(enc);
                return RubyBignum.bignorm(runtime, BigInteger.valueOf(l).and(new BigInteger("FFFFFFFFFFFFFFFF", 16)));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeLongBigEndian(result2, Pack.num2quad(o));
            }
        };
        Pack.converters[113] = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Platform.BYTE_ORDER == 4321 ? Pack.decodeLongBigEndian(enc) : Pack.decodeLongLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                this.encodeLongByByteOrder(result2, Pack.num2quad(o));
            }
        };
        Pack.converters[173] = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeLongLittleEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeLongLittleEndian(result2, Pack.num2quad(o));
            }
        };
        Pack.converters[174] = new QuadConverter(8, "Integer"){

            @Override
            public IRubyObject decode(Ruby runtime, ByteBuffer enc) {
                return runtime.newFixnum(Pack.decodeLongBigEndian(enc));
            }

            @Override
            public void encode(Ruby runtime, IRubyObject o, ByteList result2) {
                Pack.encodeLongBigEndian(result2, Pack.num2quad(o));
            }
        };
        utf8_limits = new long[]{0L, 128L, 2048L, 65536L, 0x200000L, 0x4000000L, Integer.MIN_VALUE};
    }

    private static abstract class QuadConverter
    extends Converter {
        public QuadConverter(int size2, String type2) {
            super(size2, type2);
        }

        public QuadConverter(int size2) {
            super(size2);
        }

        protected int overflowQuad(long quad) {
            return (int)(quad & 0xFFFFL);
        }

        protected void encodeShortByByteOrder(ByteList result2, int s2) {
            if (Platform.BYTE_ORDER == 4321) {
                Pack.encodeShortBigEndian(result2, s2);
            } else {
                Pack.encodeShortLittleEndian(result2, s2);
            }
        }

        protected void encodeLongByByteOrder(ByteList result2, long l) {
            if (Platform.BYTE_ORDER == 4321) {
                Pack.encodeLongBigEndian(result2, l);
            } else {
                Pack.encodeLongLittleEndian(result2, l);
            }
        }
    }

    public static abstract class Converter {
        public int size;
        public String type;

        public Converter(int size2) {
            this(size2, null);
        }

        public Converter(int size2, String type2) {
            this.size = size2;
            this.type = type2;
        }

        public String getType() {
            return this.type;
        }

        public abstract IRubyObject decode(Ruby var1, ByteBuffer var2);

        public abstract void encode(Ruby var1, IRubyObject var2, ByteList var3);
    }

    private static abstract class ConverterExecutor {
        protected Converter converter;

        private ConverterExecutor() {
        }

        public void setConverter(Converter converter) {
            this.converter = converter;
        }

        public abstract IRubyObject decode(Ruby var1, ByteBuffer var2);

        public abstract void encode(Ruby var1, IRubyObject var2, ByteList var3);
    }
}

