/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaInternalBlockBody
extends BlockBody {
    private final ThreadContext originalContext;
    private final String methodName;
    private final StaticScope dummyScope;

    public JavaInternalBlockBody(Ruby runtime, Signature signature) {
        this(runtime, null, null, signature);
    }

    public JavaInternalBlockBody(Ruby runtime, ThreadContext originalContext, String methodName, Signature signature) {
        super(signature);
        this.originalContext = originalContext;
        this.methodName = methodName;
        this.dummyScope = runtime.getStaticScopeFactory().getDummyScope();
    }

    private void threadCheck(ThreadContext yieldingContext) {
        if (this.originalContext != null && yieldingContext != this.originalContext) {
            throw yieldingContext.runtime.newThreadError("" + this.methodName + " cannot be parallelized");
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2) {
        return this.yield(context, args2, null, binding2, type2);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args2, Binding binding2, Block.Type type2, Block block) {
        return this.yield(context, args2, null, binding2, type2, block);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
        this.threadCheck(context);
        return this.yield(context, new IRubyObject[]{value2});
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, IRubyObject[] args2, IRubyObject self2, Binding binding2, Block.Type type2) {
        this.threadCheck(context);
        return this.yield(context, args2);
    }

    public abstract IRubyObject yield(ThreadContext var1, IRubyObject[] var2);

    @Override
    public StaticScope getStaticScope() {
        return this.dummyScope;
    }

    @Override
    public void setStaticScope(StaticScope newScope) {
    }

    @Override
    public String getFile() {
        return "(internal)";
    }

    @Override
    public int getLine() {
        return -1;
    }
}

