/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.RaiseArgumentErrorInstr;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;

public class CheckArityInstr
extends Instr
implements FixedArityInstr {
    public final int required;
    public final int opt;
    public final boolean rest;
    public final boolean receivesKeywords;
    public final int restKey;

    public CheckArityInstr(int required, int opt, boolean rest2, boolean receivesKeywords, int restKey) {
        super(Operation.CHECK_ARITY, EMPTY_OPERANDS);
        this.required = required;
        this.opt = opt;
        this.rest = rest2;
        this.receivesKeywords = receivesKeywords;
        this.restKey = restKey;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"req: " + this.required, "opt: " + this.opt, "*r: " + this.rest, "kw: " + this.receivesKeywords};
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new CheckArityInstr(this.required, this.opt, this.rest, this.receivesKeywords, this.restKey);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            int numArgs = ii.getArgsCount();
            if (numArgs < this.required || !this.rest && numArgs > this.required + this.opt) {
                return new RaiseArgumentErrorInstr(this.required, this.opt, this.rest, numArgs);
            }
            return null;
        }
        return new CheckArgsArrayArityInstr(ii.getArgs(), this.required, this.opt, this.rest);
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.required);
        e.encode(this.opt);
        e.encode(this.rest);
        e.encode(this.receivesKeywords);
        e.encode(this.restKey);
    }

    public static CheckArityInstr decode(IRReaderDecoder d) {
        return new CheckArityInstr(d.decodeInt(), d.decodeInt(), d.decodeBoolean(), d.decodeBoolean(), d.decodeInt());
    }

    public void checkArity(ThreadContext context, Object[] args2, Block.Type blockType) {
        IRRuntimeHelpers.checkArity(context, args2, this.required, this.opt, this.rest, this.receivesKeywords, this.restKey, blockType);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.CheckArityInstr(this);
    }
}

