/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.impl.EmbeddedGraphStore;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.Log;
import com.buschmais.jqassistant.scm.cli.task.AbstractTask;
import com.buschmais.jqassistant.scm.neo4jserver.impl.ExtendedCommunityNeoServer;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;

public class ServerTask
extends AbstractTask {
    public static final String CMDLINE_OPTION_SERVERADDRESS = "serverAddress";
    public static final String CMDLINE_OPTION_SERVERPORT = "serverPort";
    private String serverAddress;
    private int serverPort;

    @Override
    protected void executeTask(Store store) throws CliExecutionException {
        ExtendedCommunityNeoServer server;
        try {
            server = new ExtendedCommunityNeoServer((EmbeddedGraphStore)store, this.pluginRepository.getScannerPluginRepository(), this.pluginRepository.getRulePluginRepository(), this.serverAddress, this.serverPort);
        }
        catch (PluginRepositoryException e) {
            throw new CliExecutionException("Cannot get plugins.", e);
        }
        server.start();
        Log.getLog().info("Running server");
        Log.getLog().info("Press <Enter> to finish.");
        try {
            System.in.read();
        }
        catch (IOException e) {
            throw new CliExecutionException("Cannot read from console.", e);
        }
        finally {
            server.stop();
        }
    }

    @Override
    protected void addTaskOptions(List<Option> options) {
        super.addTaskOptions(options);
        OptionBuilder.withArgName((String)CMDLINE_OPTION_SERVERADDRESS);
        OptionBuilder.withDescription((String)"The binding address of the server.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_SERVERADDRESS));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_SERVERPORT);
        OptionBuilder.withDescription((String)"The binding port of the server.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_SERVERPORT));
    }

    @Override
    public void withOptions(CommandLine options) {
        this.serverAddress = this.getOptionValue(options, CMDLINE_OPTION_SERVERADDRESS, "localhost");
        this.serverPort = Integer.valueOf(this.getOptionValue(options, CMDLINE_OPTION_SERVERPORT, Integer.toString(7474)));
    }
}

