/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.Console;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerImpl;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ReportPluginRepository;
import com.buschmais.jqassistant.core.report.api.ReportHelper;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.report.impl.CompositeReportWriter;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.report.impl.XmlReportWriter;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.scm.cli.CliConfigurationException;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.CliRuleViolationException;
import com.buschmais.jqassistant.scm.cli.Log;
import com.buschmais.jqassistant.scm.cli.task.AbstractAnalyzeTask;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.io.IOUtils;

public class AnalyzeTask
extends AbstractAnalyzeTask {
    private static final String CMDLINE_OPTION_SEVERITY = "severity";
    private static final Console LOG = Log.getLog();
    private String reportDirectory;
    private Severity severity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeTask(Store store) throws CliExecutionException {
        XmlReportWriter xmlReportWriter;
        FileWriter xmlReportFileWriter;
        LOG.info("Executing analysis.");
        InMemoryReportWriter inMemoryReportWriter = new InMemoryReportWriter();
        try {
            xmlReportFileWriter = new FileWriter(this.getXmlReportFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create XML report file.", e);
        }
        try {
            xmlReportWriter = new XmlReportWriter((Writer)xmlReportFileWriter);
        }
        catch (AnalysisListenerException e) {
            throw new RuntimeException("Cannot create XML report file writer.", e);
        }
        LinkedList<Object> reportWriters = new LinkedList<Object>();
        reportWriters.add(inMemoryReportWriter);
        reportWriters.add(xmlReportWriter);
        reportWriters.addAll(this.getReportPlugins());
        try {
            CompositeReportWriter reportWriter = new CompositeReportWriter(reportWriters);
            AnalyzerImpl analyzer = new AnalyzerImpl(store, (AnalysisListener)reportWriter, Log.getLog());
            try {
                RuleSet availableRules = this.getAvailableRules();
                analyzer.execute(availableRules, this.getRuleSelection(availableRules));
            }
            catch (AnalysisException e) {
                throw new CliExecutionException("Analysis failed.", e);
            }
        }
        finally {
            IOUtils.closeQuietly((Writer)xmlReportFileWriter);
        }
        store.beginTransaction();
        Log.getLog().info("Verifying results, severity=" + (Object)((Object)this.severity));
        try {
            ReportHelper reportHelper = new ReportHelper((Console)Log.getLog());
            int conceptViolations = reportHelper.verifyConceptResults(this.severity, inMemoryReportWriter);
            int constraintViolations = reportHelper.verifyConstraintResults(this.severity, inMemoryReportWriter);
            if (conceptViolations > 0 || constraintViolations > 0) {
                throw new CliRuleViolationException("Violations detected: " + conceptViolations + " concepts, " + constraintViolations + " constraints");
            }
        }
        finally {
            store.commitTransaction();
        }
    }

    private List<ReportPlugin> getReportPlugins() throws CliExecutionException {
        try {
            ReportPluginRepository reportPluginRepository = this.pluginRepository.getReportPluginRepository();
            return reportPluginRepository.getReportPlugins(this.pluginProperties);
        }
        catch (PluginRepositoryException e) {
            throw new CliExecutionException("Cannot get report plugins.", e);
        }
    }

    private File getXmlReportFile() {
        File reportFile = new File(this.reportDirectory, "jqassistant-report.xml");
        reportFile.getParentFile().mkdirs();
        return reportFile;
    }

    @Override
    public void withOptions(CommandLine options) throws CliConfigurationException {
        super.withOptions(options);
        this.reportDirectory = this.getOptionValue(options, "reportDirectory", "jqassistant/report");
        this.severity = Severity.valueOf(this.getOptionValue(options, CMDLINE_OPTION_SEVERITY, Severity.CRITICAL.name()).toUpperCase());
    }

    @Override
    protected void addTaskOptions(List<Option> options) {
        super.addTaskOptions(options);
        OptionBuilder.withArgName((String)"reportDirectory");
        OptionBuilder.withDescription((String)"The directory for writing reports.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)"reportDirectory"));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_SEVERITY);
        OptionBuilder.withDescription((String)"The severity threshold to report a failure.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_SEVERITY));
    }
}

