/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.util.Map;
import org.rrd4j.data.LinearInterpolator;
import org.rrd4j.data.Plottable;

public class DataChunk {
    private static final String NEWLINE = System.getProperty("line.separator");
    private final long startTime;
    final int start;
    final int end;
    private final long step;
    final int dsCount;
    final double[][] data;
    private final int rows;
    private final Map<String, Integer> nameindex;

    DataChunk(Map<String, Integer> nameindex, long startTime, int start, int end, long step, int dsCount, int rows) {
        this.nameindex = nameindex;
        this.startTime = startTime;
        this.start = start;
        this.end = end;
        this.step = step;
        this.dsCount = dsCount;
        this.rows = rows;
        this.data = new double[rows][dsCount];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        long time = this.startTime;
        int row = 0;
        while (row < this.rows) {
            sb.append(time);
            sb.append(": ");
            for (int ds = 0; ds < this.dsCount; ++ds) {
                sb.append(this.data[row][ds]);
                sb.append(" ");
            }
            sb.append(NEWLINE);
            ++row;
            time += this.step;
        }
        return sb.toString();
    }

    public double[][] getData() {
        return this.data;
    }

    public Plottable toPlottable(String name) {
        Integer dsId = this.nameindex.get(name);
        if (dsId == null) {
            throw new RuntimeException("datasource not not found: " + name);
        }
        long[] date = new long[this.rows];
        double[] results = new double[this.rows];
        long time = this.startTime;
        int row = 0;
        while (row < this.rows) {
            date[row] = time;
            results[row] = this.data[row][dsId];
            ++row;
            time += this.step;
        }
        return new LinearInterpolator(date, results);
    }
}

