/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.common.report;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.Console;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.visitor.CollectRulesVisitor;
import com.buschmais.jqassistant.core.analysis.impl.RuleExecutor;
import com.buschmais.jqassistant.core.analysis.impl.RuleVisitor;
import java.util.Set;

public final class RuleHelper {
    public static final String LOG_LINE_PREFIX = "  \"";
    private Console console;

    public RuleHelper(Console console) {
        this.console = console;
    }

    public void printRuleSet(RuleSet ruleSet) throws AnalysisException {
        RuleSelection ruleSelection = RuleSelection.Builder.allOf((RuleSet)ruleSet);
        this.printRuleSet(ruleSet, ruleSelection);
    }

    public void printRuleSet(RuleSet ruleSet, RuleSelection ruleSelection) throws AnalysisException {
        CollectRulesVisitor visitor = this.getAllRules(ruleSet, ruleSelection);
        this.printValidRules(visitor);
        this.printMissingRules(visitor);
    }

    private void printValidRules(CollectRulesVisitor visitor) {
        this.console.info("Groups [" + visitor.getGroups().size() + "]");
        for (Group group : visitor.getGroups()) {
            this.console.info(LOG_LINE_PREFIX + group.getId() + "\"");
        }
        this.console.info("Constraints [" + visitor.getConstraints().size() + "]");
        for (Constraint constraint : visitor.getConstraints().keySet()) {
            this.console.info(LOG_LINE_PREFIX + constraint.getId() + "\" - " + constraint.getDescription());
        }
        this.console.info("Concepts [" + visitor.getConcepts().size() + "]");
        for (Concept concept : visitor.getConcepts().keySet()) {
            this.console.info(LOG_LINE_PREFIX + concept.getId() + "\" - " + concept.getDescription());
        }
    }

    private CollectRulesVisitor getAllRules(RuleSet ruleSet, RuleSelection ruleSelection) throws AnalysisException {
        CollectRulesVisitor visitor = new CollectRulesVisitor();
        RuleExecutor executor = new RuleExecutor((RuleVisitor)visitor);
        executor.execute(ruleSet, ruleSelection);
        return visitor;
    }

    private boolean printMissingRules(CollectRulesVisitor visitor) {
        Set missingGroups;
        Set missingConstraints;
        Set missingConcepts = visitor.getMissingConcepts();
        if (!missingConcepts.isEmpty()) {
            this.console.info("Missing concepts [" + missingConcepts.size() + "]");
            for (Object missingConcept : missingConcepts) {
                this.console.warn(LOG_LINE_PREFIX + (String)missingConcept);
            }
        }
        if (!(missingConstraints = visitor.getMissingConstraints()).isEmpty()) {
            this.console.info("Missing constraints [" + missingConstraints.size() + "]");
            for (String missingConstraint : missingConstraints) {
                this.console.warn(LOG_LINE_PREFIX + missingConstraint);
            }
        }
        if (!(missingGroups = visitor.getMissingGroups()).isEmpty()) {
            this.console.info("Missing groups [" + missingGroups.size() + "]");
            for (String missingGroup : missingGroups) {
                this.console.warn(LOG_LINE_PREFIX + missingGroup);
            }
        }
        return missingConcepts.isEmpty() && missingConstraints.isEmpty() && missingGroups.isEmpty();
    }
}

