/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.ScopePluginRepository;
import com.buschmais.jqassistant.core.plugin.impl.AbstractPluginRepository;
import com.buschmais.jqassistant.core.plugin.schema.v1.JqassistantPlugin;
import com.buschmais.jqassistant.core.plugin.schema.v1.ScopeType;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScopePluginRepositoryImpl
extends AbstractPluginRepository
implements ScopePluginRepository {
    private Map<String, Scope> scopes;

    public ScopePluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) throws PluginRepositoryException {
        super(pluginConfigurationReader);
        List<JqassistantPlugin> plugins = pluginConfigurationReader.getPlugins();
        this.scopes = Collections.unmodifiableMap(this.getScopes(plugins));
    }

    private Map<String, Scope> getScopes(List<JqassistantPlugin> plugins) throws PluginRepositoryException {
        HashMap<String, Scope> scopes = new HashMap<String, Scope>();
        for (JqassistantPlugin plugin : plugins) {
            ScopeType scopeType = plugin.getScope();
            if (scopeType == null) continue;
            for (String scopePluginName : scopeType.getClazz()) {
                Class type = this.getType(scopePluginName);
                for (Enum enumConstant : (Enum[])type.getEnumConstants()) {
                    Scope scope = (Scope)enumConstant;
                    String scopeName = scope.getPrefix() + ":" + scope.getName();
                    scopes.put(scopeName.toLowerCase(), scope);
                }
            }
        }
        return scopes;
    }

    @Override
    public Scope getScope(String name) {
        return this.scopes.get(name.toLowerCase());
    }

    @Override
    public Map<String, Scope> getScopes() {
        return this.scopes;
    }
}

