/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.plugin.impl;

import com.buschmais.jqassistant.core.analysis.api.rule.source.ClasspathRuleSource;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import com.buschmais.jqassistant.core.plugin.api.PluginConfigurationReader;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.core.plugin.api.RulePluginRepository;
import com.buschmais.jqassistant.core.plugin.schema.v1.JqassistantPlugin;
import com.buschmais.jqassistant.core.plugin.schema.v1.RulesType;
import java.util.ArrayList;
import java.util.List;

public class RulePluginRepositoryImpl
implements RulePluginRepository {
    private static final String RULE_RESOURCE_PATH = "META-INF/jqassistant-rules/";
    private ClassLoader classLoader;
    private List<RuleSource> sources;

    public RulePluginRepositoryImpl(PluginConfigurationReader pluginConfigurationReader) throws PluginRepositoryException {
        this.classLoader = pluginConfigurationReader.getClassLoader();
        this.sources = this.getRuleSources(pluginConfigurationReader.getPlugins());
    }

    @Override
    public List<RuleSource> getRuleSources() {
        return this.sources;
    }

    private List<RuleSource> getRuleSources(List<JqassistantPlugin> plugins) {
        ArrayList<RuleSource> sources = new ArrayList<RuleSource>();
        for (JqassistantPlugin plugin : plugins) {
            RulesType rulesType = plugin.getRules();
            if (rulesType == null) continue;
            for (String resource : rulesType.getResource()) {
                String resourceName = RULE_RESOURCE_PATH + resource;
                sources.add((RuleSource)new ClasspathRuleSource(this.classLoader, resourceName));
            }
        }
        return sources;
    }
}

