/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolverStrategy;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.ArtifactCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import java.io.File;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryFileResolverStrategy
implements FileResolverStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryFileResolverStrategy.class);
    private String repositoryRootPath;

    public RepositoryFileResolverStrategy(File repositoryRoot) {
        this.repositoryRootPath = repositoryRoot.getAbsolutePath().replace('\\', '/');
    }

    public Descriptor require(String path, ScannerContext context) {
        return this.match(path, context);
    }

    public Descriptor match(String path, ScannerContext context) {
        if (this.isArtifactPath(path)) {
            ArtifactCoordinates coordinates = this.getArtifactCoordinates(path);
            return ((ArtifactResolver)context.peek(ArtifactResolver.class)).find((Coordinates)coordinates, context);
        }
        return null;
    }

    private boolean isArtifactPath(String path) {
        return path.startsWith(this.repositoryRootPath);
    }

    private ArtifactCoordinates getArtifactCoordinates(String path) {
        LOGGER.debug("Resolving file '{}' within the local Maven repository.", (Object)path);
        String localPath = path.substring(this.repositoryRootPath.length() + 1);
        String[] elements = localPath.split("/");
        StringBuilder groupIdBuilder = new StringBuilder();
        for (int i = 0; i < elements.length - 3; ++i) {
            if (groupIdBuilder.length() > 0) {
                groupIdBuilder.append('.');
            }
            groupIdBuilder.append(elements[i]);
        }
        String groupId = groupIdBuilder.toString();
        String artifactId = elements[elements.length - 3];
        String version = elements[elements.length - 2];
        String fileName = elements[elements.length - 1];
        int typeSeparator = fileName.lastIndexOf(".");
        String type = fileName.substring(typeSeparator + 1);
        String mainArtifactFile = artifactId + "-" + version;
        String classifierPart = fileName.substring(mainArtifactFile.length(), typeSeparator);
        String classifier = classifierPart.isEmpty() ? null : classifierPart.substring(1);
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, type, version);
        LOGGER.debug("Determined artifact '{}' for file '{}'", (Object)artifact, (Object)path);
        return new ArtifactCoordinates((Artifact)artifact);
    }
}

