/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.m2repo.api.ArtifactProvider;
import com.buschmais.jqassistant.plugin.m2repo.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.AetherArtifactProvider;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.MavenIndex;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.MavenArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.apache.maven.index.ArtifactInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepositoryScannerPlugin
extends AbstractScannerPlugin<URL, MavenRepositoryDescriptor> {
    public static final String DEFAULT_M2REPO_DIR = "./jqassistant/data/m2repo";
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenRepositoryScannerPlugin.class);
    private static final String PROPERTY_NAME_DIRECTORY = "m2repo.directory";
    private File localDirectory;

    public boolean accepts(URL item, String path, Scope scope) throws IOException {
        return MavenScope.REPOSITORY == scope;
    }

    private MavenRepositoryDescriptor getRepositoryDescriptor(Store store, String url) {
        MavenRepositoryDescriptor repositoryDescriptor = (MavenRepositoryDescriptor)store.find(MavenRepositoryDescriptor.class, url);
        if (repositoryDescriptor == null) {
            repositoryDescriptor = (MavenRepositoryDescriptor)store.create(MavenRepositoryDescriptor.class);
            repositoryDescriptor.setUrl(url);
        }
        return repositoryDescriptor;
    }

    public void configure() {
        this.localDirectory = new File(this.getStringProperty(PROPERTY_NAME_DIRECTORY, DEFAULT_M2REPO_DIR));
    }

    public MavenRepositoryDescriptor scan(URL repositoryUrl, String path, Scope scope, Scanner scanner) throws IOException {
        if (!this.localDirectory.exists()) {
            LOGGER.info("Creating local maven repository directory {}", (Object)this.localDirectory.getAbsolutePath());
            this.localDirectory.mkdirs();
        }
        MavenRepositoryDescriptor repoDescriptor = this.getRepositoryDescriptor(scanner.getContext().getStore(), repositoryUrl.toString());
        AetherArtifactProvider artifactProvider = new AetherArtifactProvider(repositoryUrl, repoDescriptor, this.localDirectory);
        this.scan(artifactProvider, scanner);
        return repoDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan(AetherArtifactProvider artifactProvider, Scanner scanner) throws IOException {
        MavenIndex mavenIndex = artifactProvider.getMavenIndex();
        Date lastIndexUpdateTime = mavenIndex.getLastUpdateLocalRepo();
        MavenRepositoryDescriptor repositoryDescriptor = artifactProvider.getRepositoryDescriptor();
        Date lastScanTime = new Date(repositoryDescriptor.getLastUpdate());
        Date artifactsSince = lastIndexUpdateTime;
        if (lastIndexUpdateTime == null || lastIndexUpdateTime.after(lastScanTime)) {
            artifactsSince = lastScanTime;
        }
        mavenIndex.updateIndex();
        ScannerContext context = scanner.getContext();
        context.push(ArtifactResolver.class, (Object)new MavenArtifactResolver());
        context.push(ArtifactProvider.class, (Object)artifactProvider);
        try {
            Iterable<ArtifactInfo> searchResponse = mavenIndex.getArtifactsSince(artifactsSince);
            for (ArtifactInfo ai : searchResponse) {
                scanner.scan((Object)ai, ai.toString(), (Scope)MavenScope.REPOSITORY);
            }
        }
        finally {
            context.pop(ArtifactProvider.class);
            context.pop(ArtifactResolver.class);
        }
        mavenIndex.closeCurrentIndexingContext();
        repositoryDescriptor.setLastUpdate(System.currentTimeMillis());
    }
}

